# Helsinki Healthcare System

## System Overview

**Finland has universal healthcare.** Mix of public and private.

| Aspect | Public | Private |
|--------|--------|---------|
| Cost | Low (subsidized) | Higher |
| Wait time | Longer | Shorter |
| Quality | Good | Good to excellent |
| Choice | Limited | More options |

## Eligibility

### Who Qualifies for Public Healthcare

| Status | Eligible? | Notes |
|--------|-----------|-------|
| Finnish residents | Yes | Via Kela card |
| EU/EEA with EHIC | Yes | Temporary coverage |
| Working in Finland | Yes | Via employment |
| Students (registered) | Yes | After Kela registration |
| Tourists | Emergency only | Pay or insurance |
| Non-registered non-EU | No | Need insurance |

### Kela Card

**Social insurance institution card.**

Get it by:
1. Register residence at DVV
2. Apply at Kela.fi
3. Card arrives by mail

**Covers:**
- Healthcare subsidies
- Prescription subsidies
- Other social benefits

## Public Healthcare

### Health Centers (Terveysasema)

**Primary care for residents.**

Find yours:
- Based on home address
- Search at hel.fi/terveysasemat

**Services:**
- GP appointments
- Nurses
- Basic tests
- Referrals to specialists
- Vaccinations
- Mental health initial care

**Costs (2026):**

| Service | Fee |
|---------|-----|
| Doctor visit | EUR 20.90 |
| Annual cap | EUR 41.80 |
| Specialist referral | Varies |

### Appointments

**How to book:**
- Helsinki app (Maisa)
- Online portal
- Phone

**Wait times:**
- Non-urgent: Days to weeks
- Urgent: Same day often
- Emergency: Immediate

### Hospitals

**For serious conditions, emergencies, specialist care.**

Main hospitals:
- **HUS (Helsinki University Hospital)**: Major hospital system
- **Meilahti**: Main campus
- **Jorvi** (Espoo): Large hospital
- **Peijas** (Vantaa): Vantaa area

**Emergency (Paeivystys):**
- Haartman (central Helsinki)
- Open 24/7
- For urgent, non-life-threatening

**Life-threatening:** Call 112

### Specialists

**Referral system:**
- GP refers to specialist
- Wait can be weeks to months
- Public quality generally good

## Private Healthcare

### Why Choose Private

- Faster appointments
- Choose your doctor
- Specialist direct access
- Comfort, convenience

### Major Providers

| Provider | Notes |
|----------|-------|
| Mehilainen | Largest, many locations |
| Terveystalo | Second largest |
| Pihlajalinna | Growing |
| Aava | Employer focus |
| Docrates | Cancer specialty |

### Costs (Without Insurance)

| Service | Approximate Cost |
|---------|------------------|
| GP visit | EUR 80-120 |
| Specialist | EUR 120-200 |
| Lab tests | EUR 50-150 |
| MRI | EUR 300-500 |

### Occupational Healthcare

**Employers must provide:**
- Basic occupational health
- Often extended coverage
- Private clinic usually
- Often Mehilainen or Terveystalo

**Covers:**
- Work-related health
- Often general healthcare too
- Check your contract

## Prescriptions

### Pharmacies (Apteekki)

**Prescription process:**
- Doctor writes to Kanta system
- Go to any pharmacy
- Give Finnish ID
- Prescription filled

**No paper needed** - all electronic via Kanta.

**Costs:**
- Kela subsidizes many drugs
- Annual cap on costs (EUR 592.16 in 2026)
- After cap, pay EUR 2.50 per prescription

### 24h Pharmacies

- Yliopiston Apteekki (Central Station area)
- Itaekeskus
- Check locations for night needs

## Mental Health

### Public System

- Start at health center
- Referral to mental health services
- Wait times can be long
- Free or low cost

### Private Options

- Faster access
- Psychologists, psychiatrists
- Therapists (various types)
- Insurance may cover

### Crisis Resources

| Service | Contact |
|---------|---------|
| Crisis line | 09 2525 0111 |
| MIELI Mental Health | mieli.fi |
| Youth crisis | Sekasin chat |
| Emergency | 112 |

### Therapy

**Types available:**
- Psychotherapy (Kela can subsidize)
- Counseling
- Psychiatric care

**Finding therapist:**
- Vastaamo (private, online)
- Mehilainen, Terveystalo
- Kela rehabilitation psychotherapy (subsidized)

## Dental Care

### Public Dental

- Available via health center
- Long wait times
- Low cost
- Basic services

### Private Dental

- Faster
- More expensive
- EUR 80-150 for checkup
- Many providers

### Kela Reimbursement

- Partial reimbursement for private dental
- Not full coverage
- Check current rates

## Vision Care

### Eye Exams

- Opticians (Instrumentarium, Specsavers, etc.)
- EUR 30-60 for exam
- Prescriptions valid 2 years

### Glasses/Contacts

- Buy at opticians
- Online options available
- Prices vary widely

## Children's Healthcare

### Neuvola (Child Health Clinic)

**Free, comprehensive child health:**
- Pregnancy follow-up
- Baby checkups
- Vaccinations
- Development monitoring
- Parental support

**Schedule:**
- Regular appointments first years
- School health after

### Vaccinations

**National program, free:**
- All standard vaccines
- Very high coverage
- School-administered too

### Pediatric Care

- Health center for basic
- Children's Hospital (Lastenklinikka) for serious
- Private options available

## Emergencies

### When to Call 112

- Life-threatening situation
- Severe injury
- Chest pain
- Difficulty breathing
- Stroke symptoms
- Serious accident

### Emergency Rooms

**Paeivystys** (emergency clinic):
- Haartman (Helsinki center)
- Jorvi (Espoo)
- Peijas (Vantaa)

**Bring:**
- ID
- Kela card if you have it
- List of medications

### After Hours

**Not emergency but urgent:**
- Call 116 117 (health advice)
- They advise where to go
- Available 24/7

## Health Records

### Kanta (OmaKanta)

**National health record system.**

Access at kanta.fi:
- View all health records
- See prescriptions
- Check test results
- Manage consents

**Login:**
- Bank ID
- Mobile certificate
- ID card

### Privacy

- Strong data protection
- You control access
- Can restrict viewing

## Insurance Options

### Types

| Type | Coverage | Cost |
|------|----------|------|
| Travel insurance | Abroad | EUR 30-100/year |
| Private health | Faster care | EUR 50-150/month |
| Occupational | Via employer | Employer pays |
| Kela | Basic coverage | Via taxes |

### When Private Insurance Makes Sense

- Want guaranteed fast access
- Specific specialist needs
- Dental coverage
- International coverage

### Providers

- If (Mandatum)
- LahiTapiola
- OP
- Turva
- Many others
