# Practical Food Information

## Dietary Restrictions

### Vegetarian

**Awareness**: High. Most restaurants have good options.

**Dedicated restaurants:**
- Silvoplee (vegan fine dining)
- Kippo (vegan casual)
- Yes Yes Yes (vegetarian Italian)
- Fafa's (many veggie options)

**Tips:**
- Lounas buffets always have veggie options
- Ask for "kasvisruoka" (vegetarian food)
- Cheese often has animal rennet, ask if strict

### Vegan

**Growing scene**, better than many European cities.

**Common challenges:**
- Dairy in everything (butter culture)
- Check bread (often has milk)
- Hidden fish (stocks, sauces)

**Apps**: HappyCow works well in Helsinki

### Gluten-Free

**Good awareness**, many options available.

**Tips:**
- "Gluteeniton" is the word
- Rye bread is NOT gluten-free
- Many cafes have GF pastries
- Supermarkets have GF sections

### Allergies

**Staff usually informed**, especially common allergies.

**Tips:**
- Serious allergies: Call ahead
- "Olen allerginen" = I am allergic to
- Nut allergies well understood

### Halal

**Limited but available**, mostly in ethnic restaurants.

**Areas:**
- Kallio (most options)
- Hakaniemi
- Some kebab shops certified

**Tips:**
- Ask specifically about halal meat
- Chicken often easier than beef
- Some Turkish/Middle Eastern places certified

### Kosher

**Very limited**, small Jewish community.

**Tips:**
- Chabad Helsinki may help
- Mostly self-catering
- Some vegetarian options work

## Alcohol in Finland

### Legal Framework

| Age | Can Buy |
|-----|---------|
| 18+ | Beer, wine, cider (up to 5.5%) |
| 20+ | Spirits, strong wine |

### Where to Buy

**Supermarkets (until 21:00):**
- Beer up to 5.5%
- Cider, wine mixes
- No wine or spirits

**Alko (state monopoly):**
- Wine, spirits, strong beer
- Hours: ~10:00-18:00 weekdays, closes earlier Saturday
- Closed Sunday
- Only place for wine over 5.5%

**Bars/restaurants:**
- Open late
- Legal until 04:00 (most close earlier)
- Higher prices than supermarket

### Prices

| Item | Price |
|------|-------|
| Beer (0.5L supermarket) | EUR 3-4 |
| Beer (0.5L bar) | EUR 7-10 |
| Wine bottle (Alko) | EUR 10-30 |
| Wine glass (restaurant) | EUR 8-14 |
| Cocktail | EUR 12-18 |

### Culture Notes

- **Pre-drinking** common (drinking at home before going out)
- **Terrace culture** in summer (patios, outdoor seating)
- **Friday/Saturday** main drinking nights
- **Public drinking** restricted but tolerated in parks (summer)
- **Drink driving** zero tolerance (0.5 per mille limit, enforced)

## Tipping Culture

**Not expected** in Finland. Service is included.

| Situation | What to Do |
|-----------|------------|
| Good restaurant service | Round up 5-10% optional |
| Standard restaurant | Nothing expected |
| Cafe | Nothing |
| Bar | Nothing |
| Taxi | Round up euro |
| Delivery | Round up optional |

**Card payments:** Can add tip, but not expected

## Restaurant Etiquette

### Reservations
- **Fine dining**: Required, days in advance
- **Popular spots**: Weekend recommended
- **Casual**: Usually walk-in OK
- **Lunch**: Never needed

### Timing
- **Lunch rush**: 11:30-12:30
- **Dinner**: Most serve 17:00-21:00
- **Late dining**: Limited options after 21:00
- **Kitchen close**: Often 30-60 min before restaurant closes

### Payment
- **Cards**: Accepted everywhere, even small amounts
- **Cash**: Rarely needed
- **Split bills**: Ask, usually possible
- **Pay at table**: Standard

### Behavior
- **Noise level**: Generally quiet
- **Dress code**: Casual acceptable most places
- **Kids**: Welcome, high chairs available
- **Dogs**: Many places allow in terrace areas

## Seasonal Considerations

### Summer (Jun-Aug)
- Terrace season
- Fresh berries everywhere
- New potatoes (uudet perunat) obsession
- Late dining possible (light until midnight)
- Book popular terraces

### Winter (Nov-Feb)
- Hearty, warming food
- Shorter restaurant hours
- Christmas season (joulupoeytae)
- Glogi (mulled wine) everywhere

### Spring
- Vappu (May 1): Sima (mead), donuts
- Spring awakening menus
- Terrace opening anticipation

### Fall
- Wild mushroom season
- Game meats (elk, reindeer)
- Harvest menus
- Ruska (autumn color) themed

## Food Events

### Annual
- **Restaurant Day** (various): Pop-up restaurants everywhere
- **Ravintolapaivae**: Same concept
- **Flow Festival** (August): Music + food
- **Baltic Herring Market** (October): Traditional market

### Weekly
- **Saturday markets**: Fresh produce
- **Food trucks**: Rotating locations

## Grocery Shopping

### Major Chains
- **S-Group** (S-Market, Prisma): Green, loyalty card
- **Kesko** (K-Market, K-Citymarket): Orange
- **Lidl**: Budget

### Hours
- Weekdays: 7:00-21:00 or 22:00
- Saturday: 8:00-21:00
- Sunday: Limited, 12:00-18:00 typical

### Tips
- Self-checkout common
- Bags cost EUR 0.20-0.50
- Deposit on bottles (return for refund)
- Loyalty cards save money

## Delivery Options

### Apps
- **Wolt**: Dominant, Finnish company
- **Foodora**: Alternative
- Both have wide selection

### Fees
- Delivery: EUR 2-5
- Minimum orders sometimes required
- Service fees added

### Grocery Delivery
- **Wolt**: Some stores
- **S-Group app**: Prisma delivery
- **Foodie.fi**: K-Group delivery

## Food Vocabulary

| Finnish | English |
|---------|---------|
| Ravintola | Restaurant |
| Kahvila | Cafe |
| Lounas | Lunch |
| Paeivaellinen | Dinner |
| Lasku | Bill |
| Vesi | Water |
| Olut | Beer |
| Viini | Wine |
| Kasvis | Vegetarian |
| Allerginen | Allergic |
| Gluteeniton | Gluten-free |
