# Helsinki Education System

## System Overview

**Finland consistently ranks among world's best education systems.**

**Key features:**
- Free at all levels (including university)
- High teacher quality (masters required)
- Minimal standardized testing
- Focus on learning, not competition
- Late start (school at 7)
- Short school days

## Levels

| Level | Ages | Finnish Name |
|-------|------|--------------|
| Early childhood | 0-6 | Varhaiskasvatus |
| Pre-primary | 6 | Esiopetus |
| Primary | 7-12 | Peruskoulu (1-6) |
| Lower secondary | 13-15 | Peruskoulu (7-9) |
| Upper secondary | 16-18 | Lukio / Ammattikoulu |
| Higher education | 18+ | Yliopisto / AMK |

## Early Childhood (Daycare)

### Public Daycare (Paeivaekoti)

**Universal right from 9 months old.**

**Costs (income-based):**
- EUR 0-295/month per child
- Most families: EUR 100-250
- Siblings discounted
- Free for low-income

**Hours:**
- Full-day: Up to 10 hours
- Part-time options available
- Flexible scheduling

**Application:**
- Apply 4 months in advance
- Through city portal
- Placement by area, availability

### Private Daycare

**Options:**
- Private daycares (with city subsidy)
- International daycares
- English-language options

**Costs:**
- EUR 400-1,200/month
- City provides support (reduces cost)

### Home Care

**Alternative to daycare:**
- Home care allowance (kotihoidon tuki)
- EUR 350-500/month
- Until child is 3

## Pre-Primary (Esiopetus)

**Compulsory at age 6.** One year before school.

- Usually at daycare or school
- Free
- 4 hours/day minimum
- Prepares for school

## Primary and Secondary (Peruskoulu)

### Structure

**Grades 1-9, ages 7-15.**

- Same school often 1-9
- No tracking by ability
- Inclusive education
- Free materials, lunches

### Public Schools

**All public schools are good.**

- No need to "find good school"
- Local school assignment
- Can apply elsewhere if space
- Quality remarkably even

### Costs

**Free:**
- Tuition
- Materials
- Lunch
- Transport (if far)

**Family provides:**
- Clothing
- Some supplies
- Activity fees (optional)

### Schedule

- School day: 4-6 hours
- Starts age 7 (later than most countries)
- Lots of recess
- Minimal homework

### After-School (Iltapaeivaetoiminta)

- Available grades 1-2
- EUR 120-200/month
- Activities, supervision
- Apply through school

## Upper Secondary

### Two Tracks

**Academic (Lukio):**
- Prepares for university
- 3 years
- Ends with matriculation exam
- Selective admission

**Vocational (Ammattikoulu):**
- Practical skills
- Many fields
- Direct to work or further study
- 2-3 years

### Admission

Based on grades from peruskoulu:
- Calculate GPA
- Apply through joint system
- Competitive for popular lukios

## Higher Education

### Universities (Yliopisto)

**Research-focused, academic.**

Institutions:
- University of Helsinki (UH)
- Aalto University
- Many others across Finland

**Admission:**
- Entrance exams
- Very competitive
- Free tuition (even non-EU)

### Universities of Applied Sciences (AMK)

**Practical, career-focused.**

- Similar to polytechnics elsewhere
- Bachelor level
- More practical than universities
- Also free

### Costs

**Tuition: Free** (even for international students)

**Living costs:**
- EUR 700-1,200/month
- Student housing available (HOAS)
- Student benefits (Kela)

### Student Benefits

**If registered full-time:**
- Study grant (opintoraha): EUR 270/month
- Housing supplement: Up to EUR 210/month
- Student loans (low interest)
- Travel discounts
- Meal subsidies (student restaurants)

## International Schools

### Why Choose

- Continuity for expat children
- English-medium instruction
- International curriculum (IB, etc.)
- Global perspective

### Options in Helsinki Area

| School | Curriculum | Ages | Fees/Year |
|--------|------------|------|-----------|
| International School of Helsinki (ISH) | IB | 3-18 | EUR 10,000-20,000 |
| French School | French | 3-18 | EUR 5,000-8,000 |
| German School | German | 3-18 | EUR 3,000-6,000 |
| European School | European Bac | 4-18 | Based on income |
| English School | UK/Finnish | 7-18 | Free (public) |

### Notes

- **ISH most popular for expats**
- Long waiting lists often
- Apply early (year+ ahead)
- Some have entry requirements

## Finnish Language Schools

For children who do not speak Finnish:
- **Preparatory classes** (one year)
- Then join regular school
- Additional Finnish support
- Integration focused

## Adult Education

### Language Learning

**Finnish for immigrants:**
- Free courses for residents
- Integration training
- Various levels

**Providers:**
- Adult education centers
- Libraries
- Private schools

### Continuing Education

- Open universities
- Professional development
- Free or low cost
- Evening classes

## Education Quality

### Why Finland Succeeds

- **Teachers**: Masters degree required, profession respected
- **Trust**: Teachers trusted, minimal oversight
- **Equality**: Resources equal across schools
- **No tracking**: Mixed ability classes
- **Play**: Lots of recess, creative learning
- **Late start**: Formal school at 7
- **Low testing**: Minimal standardized tests

### For Expat Children

**Transition tips:**
- Finnish school very different
- Less homework, more play
- Equality focus
- May need adjustment period
- Finnish language important long-term

## School Calendar

### Academic Year

- **Fall semester**: August/September - December
- **Spring semester**: January - May/June

### Holidays

| Holiday | When | Duration |
|---------|------|----------|
| Autumn break | October | 1 week |
| Christmas | Dec-Jan | 2 weeks |
| Winter break (ski) | February | 1 week |
| Easter | Spring | 4-5 days |
| Summer | June-August | ~10 weeks |

## Resources

### Online

- **Espoo.fi, Hel.fi**: City school info
- **Opintopolku.fi**: Study portal
- **Studyinfo.fi**: Higher education
- **Kela.fi**: Student benefits

### Contacts

- School social workers
- Educational psychologists
- Student health services
- Parent associations
