# Driving in Helsinki

## Do You Need a Car?

**Most Helsinki residents do not need a car.**

### Reasons to Skip

- Excellent public transport
- Parking expensive and limited
- Winter driving challenging
- Car sharing available
- Bike-friendly (summer)

### When Car Helps

- Living in far suburbs
- Regular cottage visits
- Family with many activities
- Work outside metro area
- Frequent Ikea/Costco trips

### Recommendation

- Try 6-12 months without car first
- Use car sharing initially
- Buy only if clearly needed

## Driving License

### EU/EEA Licenses

- Valid indefinitely (with conditions)
- Register if becoming resident
- Exchange for Finnish if losing original

### Non-EU Licenses

**Valid for 1-2 years depending on origin.**

After that, must get Finnish license:
- Theory test
- Driving test
- Winter driving course (slippery conditions)

**Process:**
1. Attend driving school (usually)
2. Theory test (available in English)
3. Driving test
4. Winter driving test (slippery track)

**Cost:** EUR 1,500-2,500 total

### International Driving Permit

Useful for:
- First year driving
- Non-Latin alphabet licenses
- Get before arriving

## Car Ownership

### Buying a Car

**New:**
- Dealerships throughout city
- Prices similar to elsewhere in EU
- Car tax included

**Used:**
- Nettiauto.com (main site)
- Tori.fi
- Dealerships
- Check service history
- Registration transfer simple

### Costs

| Item | Annual Cost |
|------|-------------|
| Insurance (full) | EUR 400-800 |
| Tax (vero) | EUR 100-500 |
| Inspection (katsastus) | EUR 50-80 |
| Parking permit (center) | EUR 600-1,200 |
| Fuel (average driver) | EUR 1,500-2,500 |
| Maintenance | EUR 300-800 |

### Registration

**Traficom** handles registration.
- Online at traficom.fi
- Transfer when buying
- Keep papers in car

### Insurance

**Required:**
- Liability (liikennevakuutus)
- Covers damage to others

**Recommended:**
- Full coverage (kaskovakuutus)
- Includes own damage, theft, etc.

**Providers:**
- If (Mandatum)
- LahiTapiola
- OP
- Pohjola

## Winter Driving

### Requirements

**Winter tires mandatory December 1 - February 28.**

**Options:**
- Studded tires (nastarenkaat): Best on ice
- Friction tires (kitkarenkaat): Quieter, OK on packed snow

**Most Finns use studded tires.** Better on ice.

### Conditions

**Expect:**
- Snow-covered roads
- Ice (especially intersections)
- Dark mornings/evenings
- Reduced visibility
- Longer braking distances

### Tips

- Slow down significantly
- Increase following distance
- Know how to handle slides
- Keep windshield fluid topped up
- Engine block heater (if parking outside)

### Block Heater (Lohkolaemmitin)

**Common in Finland.**

- Keeps engine warm in cold
- Parking spaces often have outlets
- Timer plug recommended
- 2 hours before driving sufficient

## Parking

### In City Center

**Very limited and expensive.**

| Type | Cost |
|------|------|
| Street parking | EUR 4-6/hour |
| Parking garages | EUR 3-5/hour |
| Monthly garage | EUR 150-300 |
| Resident permit | EUR 600-1,200/year |

### Parking Apps

- **EasyPark**: Main app
- **MoovIt**: Alternative
- **City specific**: Hel.fi parking

### Residential Parking

**Options:**
- Resident permit (limited, lottery in some areas)
- Private garage/spot (expensive)
- Building garage (if included)

### Rules

- Pay attention to signs (complex)
- Snow clearing signs (must move car)
- Time-limited zones
- Fines: EUR 60-100+

## Traffic Rules

### Basics

| Rule | Details |
|------|---------|
| Drive on | Right side |
| Speed limits | 30-120 km/h |
| Seat belts | All passengers required |
| Headlights | Always on |
| Phone | Hands-free only |
| Alcohol | 0.5 per mille max |

### Right of Way

- **Trams always have priority**
- Yield to right at unmarked intersections
- Pedestrians at crossings
- Cyclists treated as vehicles

### Speed Limits

| Location | Limit |
|----------|-------|
| City centers | 30-40 km/h |
| Urban areas | 50 km/h |
| Ring roads | 60-80 km/h |
| Highways | 80-120 km/h |

**Fines are income-based.** High earners pay much more.

### Drink Driving

**Strictly enforced.**

- Limit: 0.5 per mille
- Police checks common
- Random breathalyzers
- Penalties severe (license, fines, jail possible)

**Zero tolerance culture.** Do not risk it.

## Alternatives to Owning

### Car Sharing

| Service | Type |
|---------|------|
| 24Rent | Station-based |
| ShareNow | Not in Helsinki yet |
| Various | Apps emerging |

### Rental

- Hertz, Europcar, Sixt
- Budget-friendly for occasional use
- Book early for weekends

### Taxis

- Expensive but available
- Apps: Uber, Bolt, Taksi Helsinki
- Airport: Fixed prices available

### Combination Strategy

1. HSL for daily transport
2. Car sharing for weekend trips
3. Rental for cottage weeks
4. Taxi for special occasions

**Often cheaper than owning.**

## Road Trips from Helsinki

### Popular Destinations

| Destination | Distance | Drive Time |
|-------------|----------|------------|
| Porvoo | 50 km | 50 min |
| Turku | 170 km | 2h |
| Tampere | 180 km | 2h |
| Tallinn (ferry) | - | 2h ferry |
| Lapland (Rovaniemi) | 830 km | 9h |
| Stockholm (ferry) | - | Overnight |

### Road Conditions

- Generally excellent
- Well-maintained
- Winter: Plowed regularly
- Some rural roads less maintained

### Toll Roads

**No tolls in Finland.** All roads free.

### Gas Stations

- Shell, Neste, ABC, ST1
- Well-distributed
- Pay at pump common
- EV charging growing

## Electric Vehicles

### Growing Rapidly

- Government incentives
- Charging infrastructure expanding
- Cold weather affects range
- Popular choices: Tesla, VW ID, Hyundai/Kia

### Charging

**Options:**
- Home charging (best)
- Public chargers (K-Lataus, Virta, etc.)
- Superchargers for Tesla

**Cold weather:**
- Range reduced 20-30% in winter
- Pre-conditioning helps
- Plan longer trips carefully

### Benefits

- No car tax (0 emissions)
- Cheaper to run
- Growing charging network
- Good for short trips

### Challenges

- Long trips require planning
- Cold range reduction
- Apartment charging can be tricky
- Higher purchase price

## Summary

**For most Helsinki residents:**
1. Use public transport daily
2. Car share for occasional needs
3. Rent for vacations/cottage
4. Own only if clearly necessary

**If you do own:**
- Budget EUR 4,000-6,000/year minimum
- Winter tires essential
- Learn winter driving
- Consider EV
