# Helsinki Cost of Living

## Monthly Budget Overview

### Single Person

| Category | Budget | Mid-Range | Comfortable |
|----------|--------|-----------|-------------|
| Rent (1BR) | EUR 900 | EUR 1,200 | EUR 1,500 |
| Utilities | EUR 80 | EUR 100 | EUR 120 |
| Groceries | EUR 250 | EUR 350 | EUR 450 |
| Transport | EUR 63 | EUR 63 | EUR 100 |
| Phone/Internet | EUR 40 | EUR 50 | EUR 60 |
| Entertainment | EUR 100 | EUR 200 | EUR 400 |
| Eating out | EUR 100 | EUR 200 | EUR 400 |
| Other | EUR 100 | EUR 200 | EUR 300 |
| **Total** | **EUR 1,633** | **EUR 2,363** | **EUR 3,330** |

### Couple (Shared Apartment)

| Category | Budget | Mid-Range | Comfortable |
|----------|--------|-----------|-------------|
| Rent (2BR) | EUR 1,300 | EUR 1,600 | EUR 2,000 |
| Utilities | EUR 120 | EUR 150 | EUR 180 |
| Groceries | EUR 400 | EUR 550 | EUR 700 |
| Transport | EUR 126 | EUR 126 | EUR 150 |
| Phone/Internet | EUR 60 | EUR 80 | EUR 100 |
| Entertainment | EUR 200 | EUR 350 | EUR 600 |
| Eating out | EUR 200 | EUR 400 | EUR 700 |
| Other | EUR 150 | EUR 300 | EUR 500 |
| **Total** | **EUR 2,556** | **EUR 3,556** | **EUR 4,930** |

### Family (2 Adults + 2 Kids)

| Category | Budget | Mid-Range | Comfortable |
|----------|--------|-----------|-------------|
| Rent (3BR) | EUR 1,500 | EUR 1,800 | EUR 2,500 |
| Utilities | EUR 150 | EUR 180 | EUR 220 |
| Groceries | EUR 600 | EUR 800 | EUR 1,000 |
| Transport | EUR 126 | EUR 150 | EUR 200 |
| Childcare | EUR 0-300 | EUR 300-600 | EUR 300-600 |
| Activities | EUR 100 | EUR 200 | EUR 400 |
| Other | EUR 300 | EUR 500 | EUR 800 |
| **Total** | **EUR 2,776** | **EUR 3,930** | **EUR 5,720** |

Note: Public education and healthcare mostly free.

## Housing Costs

### Rent by Area (1BR, Feb 2026)

| Area | Budget | Average | Premium |
|------|--------|---------|---------|
| City Center | EUR 1,400 | EUR 1,600 | EUR 2,000+ |
| Punavuori | EUR 1,200 | EUR 1,400 | EUR 1,800 |
| Kallio | EUR 900 | EUR 1,100 | EUR 1,400 |
| Toeoeloe | EUR 1,100 | EUR 1,300 | EUR 1,600 |
| Lauttasaari | EUR 1,000 | EUR 1,200 | EUR 1,500 |
| Tapiola (Espoo) | EUR 950 | EUR 1,150 | EUR 1,400 |
| Itaekeskus | EUR 750 | EUR 900 | EUR 1,100 |
| Vantaa | EUR 700 | EUR 900 | EUR 1,100 |

### Additional Housing Costs

| Item | Typical |
|------|---------|
| Security deposit | 1-3 months rent |
| Agency fee (if used) | 1 month rent |
| Electricity | EUR 30-80/month |
| Water (if separate) | EUR 20-40/month |
| Home insurance | EUR 10-20/month |
| Internet | EUR 25-40/month |

## Food Costs

### Grocery Prices (Feb 2026)

| Item | Price |
|------|-------|
| Milk (1L) | EUR 1.00-1.50 |
| Bread (loaf) | EUR 2.00-4.00 |
| Eggs (12) | EUR 3.00-4.50 |
| Chicken breast (kg) | EUR 8-12 |
| Salmon (kg) | EUR 15-25 |
| Rice (kg) | EUR 2-3 |
| Apples (kg) | EUR 2-4 |
| Beer (0.5L) | EUR 2.50-4.00 |
| Wine bottle | EUR 8-15 (Alko) |

### Restaurant Prices

| Type | Price Range |
|------|-------------|
| Lounas (lunch buffet) | EUR 11-16 |
| Casual dinner | EUR 18-30 |
| Mid-range restaurant | EUR 35-55 |
| Fine dining | EUR 80-150+ |
| Coffee | EUR 3.50-5.00 |
| Beer (bar) | EUR 7-10 |
| Fast food meal | EUR 10-14 |

### Budget Food Tips
- Lounas (lunch) is best value
- Cook at home most days
- Lidl for budget groceries
- Ethnic restaurants often cheaper
- Market halls for quality/price

## Transport Costs

### HSL Public Transport

| Pass | Price/Month |
|------|-------------|
| AB zone (Helsinki) | EUR 62.70 |
| ABC zone (+ Vantaa/airport) | EUR 74.00 |
| ABCD zone (full region) | EUR 88.70 |

### Other Transport

| Item | Cost |
|------|------|
| Single HSL ticket (AB) | EUR 2.95 |
| Day ticket (AB) | EUR 9.50 |
| City bike (season) | EUR 35 |
| Taxi (city trip) | EUR 15-30 |
| Taxi (airport) | EUR 45-55 |
| Gas (per liter) | EUR 1.80-2.20 |
| Car parking (center/hour) | EUR 4-6 |

## Childcare and Education

### Daycare (Paeivaekoti)

**Public (income-based):**
- EUR 0-295/month per child
- Based on income and family size
- Most families pay EUR 100-250

**Private:**
- EUR 400-1,200/month
- City subsidy available (reduces cost)

### Schools

**Public schools:** Free
- Includes materials, lunch, transport if needed
- High quality

**Private/International:**
- EUR 5,000-20,000/year
- International School of Helsinki (ISH)
- French, German schools

## Healthcare Costs

### Public Healthcare

| Service | Cost |
|---------|------|
| GP visit | EUR 20-40 |
| Specialist | EUR 40-60 |
| Hospital day | EUR 49 (capped) |
| Annual cap | EUR 692 (2026) |
| Prescriptions | Partial coverage |

### Private Healthcare

| Service | Cost |
|---------|------|
| GP visit | EUR 80-150 |
| Specialist | EUR 150-300 |
| Private insurance | EUR 50-150/month |

## Taxes

### Income Tax (Combined Rate)

| Gross Income | Approximate Tax Rate |
|--------------|---------------------|
| EUR 20,000 | ~20% |
| EUR 40,000 | ~30% |
| EUR 60,000 | ~38% |
| EUR 80,000 | ~42% |
| EUR 100,000 | ~45% |

Includes state tax, municipal tax, church tax (optional).

### What Taxes Fund
- Healthcare (mostly free)
- Education (completely free)
- Social security
- Parental leave
- Unemployment benefits
- Public infrastructure

## Comparison: Helsinki vs Other Cities

| City | Cost Index | Notes |
|------|------------|-------|
| Helsinki | 100 | Base |
| Stockholm | 105 | Similar, slightly higher |
| Copenhagen | 110 | Higher overall |
| Oslo | 115 | Higher, especially alcohol |
| London | 120 | Much higher rent |
| Zurich | 140 | Significantly higher |
| Tallinn | 70 | Much cheaper |
| Berlin | 80 | Cheaper, esp. rent |

## Salary Expectations

### Net vs Gross

Rough calculation:
- Gross EUR 50,000/year
- Tax ~30%
- Net EUR 35,000/year
- Monthly net ~EUR 2,900

### By Profession (Gross Monthly)

| Role | Junior | Mid | Senior |
|------|--------|-----|--------|
| Software Dev | EUR 3,500 | EUR 4,500 | EUR 6,000 |
| Marketing | EUR 2,800 | EUR 3,500 | EUR 4,500 |
| Finance | EUR 3,200 | EUR 4,200 | EUR 5,500 |
| Teacher | EUR 2,800 | EUR 3,200 | EUR 3,800 |
| Nurse | EUR 2,600 | EUR 3,000 | EUR 3,500 |
| Service | EUR 2,200 | EUR 2,500 | EUR 2,900 |

## Money-Saving Tips

### Housing
- Consider suburbs (Espoo, Vantaa)
- Roommate if single
- Smaller apartment than you think

### Food
- Cook at home
- Lounas for weekday lunches
- Loyalty cards (S-bonus, K-Plussa)
- Lidl for basics

### Transport
- Monthly pass if commuting
- Bike in summer
- Walk - city is compact

### Entertainment
- Free museums (first Friday)
- Library system (Oodi)
- Nature is free
- Student discounts (if applicable)
- Happy hours for drinks
