# Helsinki Weather and Climate

## Annual Overview

| Month | Avg High | Avg Low | Daylight | Character |
|-------|----------|---------|----------|-----------|
| Jan | -2C | -8C | 6-7h | Dark, cold, snow |
| Feb | -2C | -9C | 8-10h | Coldest, some light return |
| Mar | 2C | -5C | 11-13h | Still cold, spring hints |
| Apr | 9C | 1C | 14-16h | Thaw begins, unpredictable |
| May | 16C | 6C | 17-19h | Spring arrives, Vappu |
| Jun | 20C | 11C | 19-24h | White nights, summer starts |
| Jul | 23C | 14C | 18-19h | Warmest, peak summer |
| Aug | 21C | 13C | 15-17h | Still summer, nights darken |
| Sep | 15C | 8C | 12-14h | Fall begins, ruska colors |
| Oct | 8C | 3C | 9-11h | Getting dark, rain |
| Nov | 3C | -2C | 6-8h | Dark, cold, pre-winter |
| Dec | 0C | -5C | 5-6h | Darkest, holiday lights |

## Seasons in Detail

### Winter (December - February)

**What to expect:**
- Snow on ground (usually)
- Temperatures -5C to -15C typical
- Can drop to -25C occasionally
- Very short days (4-7 hours)
- Dark mornings and evenings

**Survival strategies:**
- Quality winter coat (down or wool)
- Waterproof, insulated boots with grip
- Layers (thermal base essential)
- Warm hat, gloves, scarf
- Vitamin D supplements
- Light therapy lamp
- Accept indoor activities
- Embrace hygge/cozy culture

**Activities:**
- Cross-country skiing (Paloheinae, Central Park)
- Ice skating (natural and rinks)
- Sauna (peak season)
- Museums, cafes, indoor life
- Christmas markets (December)
- Lux Helsinki (January)

### Spring (March - May)

**What to expect:**
- Unpredictable weather
- Snow melts March-April
- Temperatures 0C to 15C
- Rapidly lengthening days
- Mud season (slush)

**Survival strategies:**
- Waterproof shoes essential
- Layers for variable weather
- Enjoy returning light
- Plan for Vappu (May 1)

**Activities:**
- Vappu celebrations (huge)
- First terrace openings
- Parks awakening
- Archipelago opening up

### Summer (June - August)

**What to expect:**
- Long days (nearly 24h light in June)
- Temperatures 15-25C
- Occasional hot days (30C+)
- Rain showers possible
- Locals on vacation (July)

**Survival strategies:**
- Light layers (evenings cool)
- Sunscreen (long exposure)
- Sleep mask (light nights)
- Embrace outdoor life
- Book accommodations early

**Activities:**
- Terraces, outdoor dining
- Island hopping
- Swimming (sea, lakes)
- Festivals (Flow, etc.)
- Midnight sun experience
- Cycling everywhere
- Berry picking

### Fall (September - November)

**What to expect:**
- Cooling rapidly
- Ruska (autumn colors) Sep-Oct
- Rain increasing
- Dark returning fast
- First snow possible late October

**Survival strategies:**
- Waterproof jacket
- Prepare for winter
- Enjoy ruska while it lasts
- Stock up on vitamin D

**Activities:**
- Mushroom picking (Sep-Oct)
- Ruska hikes
- Sauna season begins
- Cozy cafe culture
- Museums, cultural events

## Daylight Hours

| Date | Sunrise | Sunset | Total |
|------|---------|--------|-------|
| Dec 21 (shortest) | 9:24 | 15:13 | 5h 49m |
| Mar 21 (equinox) | 6:27 | 18:41 | 12h 14m |
| Jun 21 (longest) | 3:54 | 22:50 | 18h 56m |
| Sep 21 (equinox) | 7:02 | 19:15 | 12h 13m |

**Note:** In June, it never gets fully dark. Civil twilight all night.

## Coping with Darkness

### Seasonal Affective Disorder (SAD)

Common in Finland. Finns have extensive experience managing it.

**Symptoms:**
- Low energy
- Oversleeping
- Carbohydrate cravings
- Mood changes
- Social withdrawal

**Strategies:**
- **Light therapy lamps** (10,000 lux, 20-30 min/morning)
- **Vitamin D** (many Finns take 50-100 mcg/day)
- **Exercise** (indoor or outdoor)
- **Maintain routines**
- **Social connection**
- **Embrace hygge** (cozy culture)
- **Sauna** (traditional mood booster)
- **Travel** (many take winter sun holidays)

### Light Therapy

- Available at many cafes, libraries
- Buy personal lamp (Philips, Lumie brands)
- Use in morning, not evening
- 20-30 minutes while having breakfast

## Extreme Weather

### Cold Snaps

Occasionally -25C to -30C.

**What happens:**
- Schools may close
- Outdoor time limited
- Cars may not start
- Pipes can freeze

**Preparation:**
- Stay inside if possible
- Limit exposed skin time
- Watch for frostbite signs
- Keep phones warm (batteries die)

### Heat Waves

Rare but increasing. Occasionally 30C+.

**What happens:**
- No AC in most buildings
- Lakes fill with swimmers
- Sleep difficult (light + heat)
- Public cooling areas open

**Coping:**
- Fans
- Swimming
- Cool showers
- Evening activities

### Storms

Generally mild compared to many countries.
- Occasional strong winds
- Thunder in summer
- Check forecasts before outdoor activities

## Practical Weather Tips

### Dressing

| Season | Essentials |
|--------|------------|
| Winter | Down coat, wool layers, thermal base, waterproof boots, hat, gloves |
| Spring | Layers, waterproof jacket, waterproof shoes |
| Summer | Light layers, rain jacket, sunglasses |
| Fall | Waterproof everything, warm layers |

### Apps and Forecasts

- **FMI** (Ilmatieteen laitos): Official Finnish weather
- **Yr.no**: Norwegian, very accurate for Nordics
- **Apple/Google Weather**: Adequate

### Indoor/Outdoor Planning

**Always have backup indoor plan in winter.**

| Season | Outdoor OK | Indoor Backup |
|--------|------------|---------------|
| Winter | Short activities, skiing | Museums, sauna, cafes |
| Spring | Depends on day | Many options |
| Summer | Most activities | Rare need |
| Fall | Weather-dependent | Always ready |

## What to Pack

### Short Visit (Any Season)
- Check forecast for your dates
- Layers always
- Waterproof outer layer
- Comfortable walking shoes

### Moving to Helsinki

**Winter kit:**
- Quality winter coat (invest!)
- Waterproof insulated boots
- Thermal underwear (Uniqlo Heattech, etc.)
- Wool sweaters
- Hat, gloves, scarf
- Ice grips for shoes

**Summer kit:**
- Light layers
- Rain jacket
- Sunglasses
- Swimsuit

**All year:**
- Vitamin D
- Light therapy lamp
- Good indoor shoes/slippers
