# Starting a Business in Helsinki

## Business Environment

**Finland ranks highly for:**
- Ease of doing business
- Low corruption
- Rule of law
- Digital infrastructure
- Educated workforce

**Challenges:**
- High taxes
- Small domestic market
- Language barrier (outside English)
- Bureaucracy (though improving)
- Labor market regulations

## Legal Structures

### Common Business Forms

| Form | Finnish Name | Use Case |
|------|--------------|----------|
| Limited company | Osakeyhtioe (Oy) | Most businesses, limited liability |
| Sole proprietor | Toiminimi | Freelancers, simple |
| Partnership | Avoin yhtioe | Small partnerships |
| Limited partnership | Kommandiittiyhtioe | Investment structures |
| Cooperative | Osuuskunta | Member-owned |
| Branch | Sivuliike | Foreign company branch |

### Osakeyhtioe (Oy) - Most Common

**Requirements:**
- Minimum share capital: EUR 2,500
- One shareholder minimum
- Board of directors (can be one person)
- Finnish address for registration

**Benefits:**
- Limited liability
- Credibility
- Can hire employees easily
- Standard structure

**Registration:**
- PRH (Patent and Registration Office)
- ytj.fi online
- 1-2 weeks processing
- EUR ~280 registration fee

## Registration Process

### Steps to Start Oy

1. **Choose company name**
   - Check availability at PRH
   - Must be unique
   - Can reserve in advance

2. **Draft documents**
   - Memorandum of association
   - Articles of association
   - Shareholder agreement (recommended)

3. **Open bank account**
   - Deposit share capital (EUR 2,500+)
   - Get confirmation

4. **Register with PRH**
   - Online at ytj.fi
   - Submit documents
   - Pay fee

5. **Receive Business ID (Y-tunnus)**
   - 1-2 weeks
   - Needed for everything

6. **Register for tax**
   - VAT if applicable
   - Employer register if hiring
   - Prepayment register

### Sole Proprietor (Toiminimi)

Simpler for freelancers:
- No minimum capital
- Personal liability
- Register at PRH
- EUR ~60 registration

## Taxes

### Corporate Tax

**Rate: 20%** on profits

Lower than many EU countries.

### VAT (ALV)

| Rate | Applies To |
|------|-----------|
| 24% | Standard rate |
| 14% | Food, restaurants |
| 10% | Books, culture, transport |
| 0% | Exports, some services |

**Registration:**
- Required if revenue > EUR 15,000/year
- Voluntary below threshold
- File returns monthly/quarterly

### Employer Costs

When hiring, add ~25% to salary:
- Pension (TyEL): ~17%
- Health insurance: ~1.5%
- Unemployment: ~1.5%
- Other: ~5%

### Personal Taxation

If paying yourself salary:
- Progressive income tax (30-50%)
- Dividends taxed differently
- Consult accountant for optimization

## Support and Funding

### Government Support

**Business Finland:**
- Grants for R&D
- Internationalization funding
- Startup grants
- Up to 50% of eligible costs

**ELY Center:**
- Development grants
- Salary support for hiring
- Internationalization

**TE Services:**
- Startup grant (starttiraha)
- EUR 750-900/month for 6-12 months
- For unemployed starting business

### Private Funding

**Accelerators:**
- Slush ecosystem
- Maria 01 connections
- STING (Swedish, Nordic reach)

**VCs and Angels:**
- Active Nordic scene
- Finnish Business Angels (FiBAN)
- Nordic VCs invest early stage

**Banks:**
- Finnvera guarantees
- Bank loans possible with guarantee

## Practical Matters

### Bank Account

**Business account required for Oy.**

Options:
- Nordea, OP, Danske (traditional)
- Holvi (fintech, popular with startups)
- Wise Business (international)

Requirements:
- Y-tunnus
- Company documents
- Beneficial owner info
- KYC process

### Accounting

**Required:** All companies must have accounts.

**Options:**
- DIY with software (small)
- Accountant (recommended)
- Full-service firms

**Costs:**
- Basic bookkeeping: EUR 100-300/month
- Full service: EUR 300-800/month

**Popular software:**
- Procountor
- Netvisor
- Holvi (built-in simple)

### Insurance

**Required:**
- TyEL (pension) if employees
- Liability depends on industry

**Recommended:**
- Liability insurance
- Legal expense insurance
- Key person insurance

### Office Space

**Options:**
- Home office (allowed)
- Coworking: EUR 200-500/month
- Private office: EUR 500-1,500/month
- Maria 01: Startup pricing available

**Coworking spaces:**
- Maria 01 (startup focus)
- Mothership
- WeWork
- Epicenter
- Spaces

## Hiring

### Employment Contracts

**Required elements:**
- Job description
- Salary
- Working hours
- Notice periods
- Collective agreement (if applicable)

**Types:**
- Permanent (toistaiseksi)
- Fixed-term (maaeraeaikainen)
- Part-time

### Collective Agreements (TES)

Many industries have:
- Minimum wages
- Working conditions
- Benefits requirements
- Check if applies to you

### Notice Periods

| Tenure | Employee | Employer |
|--------|----------|----------|
| < 1 year | 14 days | 14 days |
| 1-4 years | 1 month | 1 month |
| 4-8 years | 1 month | 2 months |
| > 8 years | 1 month | 4-6 months |

## International Business

### From Finland

- EU single market access
- Easy to export services
- Digital services globally
- Good reputation

### Branches

Foreign companies can:
- Establish branch (sivuliike)
- Register with PRH
- No minimum capital
- Subject to Finnish tax on Finnish income

## Resources

### Government

- **PRH** (prh.fi): Registration
- **Vero** (vero.fi): Taxes
- **Business Finland**: Funding, support
- **Enterprise Finland**: Information portal
- **TE Services**: Employment, startup support

### Private

- **Accountants**: Find via Taloushallintoliitto
- **Lawyers**: Finnish Bar Association
- **NewCo Helsinki**: Free advice for new entrepreneurs
- **Yrittaejat**: Entrepreneur association

### Startup Specific

- **Slush**: Conference, community
- **Maria 01**: Campus
- **Startup Foundation**: Early support
- **FiBAN**: Angel investors
