---
name: Hebrew
description: Write Hebrew that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Hebrew is technically correct but sounds off. Too formal. Too literary. Natives write more casually, with slang and shortcuts. Match that.

## Formality Default

Default register is too high. Israeli Hebrew is notably informal. Unless explicitly formal: lean casual. "היי" not "שלום". "אוקיי" not "בסדר גמור".

## Formal vs Casual

Hebrew registers:
- Formal: news, academia, official documents
- Casual: daily life, texting, online
- Israeli culture is very informal
- Over-formal = stiff, foreign

## Gender Agreement

Hebrew marks gender throughout:
- Verbs, adjectives, pronouns agree with gender
- Get this right—it's fundamental
- Masculine plural as default for mixed groups
- But be natural, not robotic about it

## Slang & Shortcuts

Common casual patterns:
- בסדר → בסדגמור, סבבה
- תודה → תודות, תנקס
- נו → emphasis, impatience
- יאללה → let's go, come on

## Particles & Fillers

These make Hebrew natural:
- נו: impatience, emphasis ("נו אז?")
- כאילו: "like" filler
- סתם: "just", "for no reason"
- ממש: "really", emphasis
- בכלל: "at all", "in general"

## Fillers & Flow

Real Hebrew has fillers:
- אז, נו, כאילו
- יעני, סתם, ממש
- אוקיי, טוב
- בקיצור, בעצם

## Expressiveness

Don't pick the safe word:
- טוב → מעולה, אדיר, על הפנים (great)
- רע → גרוע, נורא, חרא
- מאוד → ממש, לגמרי, מלא

## Common Expressions

Natural expressions:
- סבבה, אחלה, יאללה
- אין בעיה, הכל טוב
- מה קורה?, מה נשמע?
- באסה, חבל, יופי

## Reactions

React naturally:
- באמת?, רצינית?, מה?
- וואו!, יאללה!, אלוהים!
- אחלה!, מדהים!, סבבה!
- חחח, lol in text

## English Mixing

Israelis mix English naturally:
- "זה היה super awkward"
- "Nice אחד"
- Very common in casual speech

## The "Native Test"

Before sending: would an Israeli screenshot this as "AI-generated"? If yes—too formal, no slang, no יאללה. Add sabra flavor.
