---
name: healthy-eating
description: Build healthy eating habits with meal logging, nutrition tracking, and food choices
author: clawd-team
version: 1.0.0
triggers:
  - "log meal"
  - "what should I eat"
  - "healthy eating"
  - "nutrition check"
  - "food choices"
---

# Healthy Eating

Build sustainable nutrition habits through simple meal logging and mindful food choices.

## What it does

Log meals without obsession. Get real-time nutrition awareness. Receive personalized suggestions for healthier choices. Track patterns over time and build habits that stick—no calorie counting required.

## Usage

**Log meals**
- Record what you ate and when
- Capture portion sizes and meal context (breakfast, snack, lunch, dinner)
- Notes on how you felt after eating

**Get suggestions**
- Ask for healthy meal ideas based on ingredients you have
- Get quick swaps for favorite foods
- Receive context-aware recommendations (late night, busy day, social event)

**Check nutrition**
- View nutrient breakdown: proteins, fats, carbs, fiber, micronutrients
- Understand food quality and satiety impact
- See hydration status and daily totals

**Meal planning**
- Plan weekly meals with minimal friction
- Balance macros and whole foods naturally
- Batch prep suggestions for busy schedules

**Track habits**
- View eating patterns over days and weeks
- Spot triggers and improvements
- Celebrate consistency milestones

## Food Categories

**Proteins**
Lean meats, fish, eggs, legumes, nuts, seeds, Greek yogurt

**Vegetables**
Leafy greens, cruciferous, root veggies, colorful variety

**Whole grains**
Oats, brown rice, quinoa, whole wheat, barley

**Healthy fats**
Olive oil, avocados, fatty fish, nuts, seeds

**Hydration**
Water, herbal tea, electrolyte balance

## Tips

- Log immediately after eating—memory fades but patterns stick
- Focus on food quality and how your body feels, not numbers on a screen
- Pair proteins with veggies at every meal to stabilize energy and hunger
- Plan meals on Sundays so weekday choices default to healthy options
- All data stays local on your machine

