# Coverage Framework — Health Insurance

Use this framework before recommending any plan.

## 1. Network Fit

- Confirm required providers and hospitals are in-network.
- Check whether in-network status changes by service type.
- Flag narrow-network plans when continuity risk is high.

## 2. Cost-Sharing Structure

Evaluate these as one system:
- Monthly premium
- Deductible
- Coinsurance rate
- Out-of-pocket maximum
- Copay structure by service type

## 3. Access Friction

Check operational friction that affects real-world usability:
- Referral requirements
- Prior authorization burden
- Telehealth availability
- Out-of-area coverage behavior

## 4. Medication Reliability

- Verify formulary coverage for ongoing prescriptions.
- Check tier level and prior-authorization requirements.
- Estimate worst-case out-of-pocket if medication changes occur.

## 5. Risk Alignment

Map plan type to risk tolerance:
- Low-risk tolerance: prioritize predictable copays and lower downside.
- High-risk tolerance: high deductible options may be acceptable if premium savings are significant.
- Chronic care profile: prioritize low friction and medication continuity over minimum premium.
