# 출력 템플릿

> 공통 Flash/Deep-Dive 구조: [`../../common/output_templates_base.md`](../../common/output_templates_base.md)

---

## Flash Layer (항상 출력, 20~40줄)

```markdown
### 🏥 [증상/질환/약명] 건강 정보 (as of YYYY-MM-DD)
**기준:** 국가건강정보포털 / 식약처 공식 정보

**한 줄 요약:** …

| 항목 | 내용 |
|------|------|
| … | … |

**권고 행동**
1. [즉시 할 것]
2. [병원 방문 기준]
3. [주의사항]

⚠️ 본 내용은 일반 건강 정보이며, 의학적 진단·처방이 아닙니다.
증상이 지속되면 반드시 의사 진료를 받으세요. 응급 시 119.
```

---

## 인텐트별 특화 템플릿

### Symptom Check Flash
```markdown
### 🏥 증상 분석 — [증상 설명]

**가능한 원인 (확정 진단 아님)**
| 증상 | 의심 질환 범위 | 권고 진료과 |
|------|--------------|-----------|
| [증상1] | [질환A, 질환B] | [진료과] |

**진료과 안내**
- 🏥 **[추천 진료과]** — [이유]
- 🏥 **[대안 진료과]** — [이유]

**지금 병원 가야 하나요?**
- ✅ 지금 당장: [이런 증상이면]
- 🟡 오늘 내로: [이런 경우]
- 🟢 며칠 지켜봐도: [이런 경우]

⚠️ 진단이 아닙니다. 증상 지속 시 반드시 진료받으세요.
```

### Drug Info Flash
```markdown
### 💊 의약품 정보 — [약품명]

| 항목 | 내용 |
|------|------|
| 성분 | [주성분] |
| 효능/효과 | [주요 효능] |
| 용법/용량 | [일반적 용법 — 반드시 의사·약사 지시 따를 것] |
| 주요 부작용 | [주요 부작용 1~3개] |
| 주의사항 | [임산부/수유부/노인/어린이 등] |
| 병용 금기 | [같이 먹으면 안 되는 약/음식] |

⚠️ 용법·용량은 의사·약사 처방에 따르세요. 임의 복용 금지.
```

### Emergency Guide Flash
```markdown
### 🚨 응급 판단 가이드

**즉시 119 신고해야 하는 상황**
- 🔴 흉통 (특히 왼쪽, 압박감·조이는 느낌)
- 🔴 갑작스러운 호흡 곤란
- 🔴 의식 저하·상실
- 🔴 한쪽 팔다리 갑작스러운 마비
- 🔴 갑자기 말이 안 나오거나 발음이 이상해짐
- 🔴 심한 출혈 (압박으로 멈추지 않는)
- 🔴 고열(39°C↑) + 경련

**응급실 vs 일반 병원**
| 상황 | 권고 |
|------|------|
| 위 증상 해당 | 즉시 119 또는 응급실 |
| 심한 통증 | 응급실 |
| 발열·두통·복통 (경미) | 일반 병원·의원 |
| 만성 증상 악화 | 담당 주치의 |

📞 응급: **119** | 비응급 의료상담: **1339** (24시간)
```

### Health Checkup Flash
```markdown
### 🏥 국가건강검진 안내

**일반건강검진 (2년 1회, 짝/홀수 해에 따라)**
| 대상 | 검진 내용 |
|------|---------|
| 만 20세↑ 세대원 | 혈압·혈당·콜레스테롤·간기능 등 |
| 만 40세↑ | 위암 검진 추가 |
| 만 50세↑ 여성 | 유방암·자궁경부암 추가 |

**5대 암 검진 (무료, 건강보험 가입자)**
| 암종 | 대상 | 주기 |
|------|------|------|
| 위암 | 만 40세↑ | 2년 |
| 대장암 | 만 50세↑ | 1년 |
| 간암 | 고위험군 | 6개월 |
| 유방암 | 만 40세↑ 여성 | 2년 |
| 자궁경부암 | 만 20세↑ 여성 | 2년 |

→ 국민건강보험공단 앱/사이트에서 본인 해당 검진 확인 가능
```

### Mental Health Flash
```markdown
### 🧠 정신건강 정보 — [증상]

**자가 체크**
- [ ] [체크 항목 1]
- [ ] [체크 항목 2]
- [ ] [체크 항목 3]

**대처 방법**
1. [즉시 할 수 있는 것]
2. [생활 습관 개선]
3. [전문가 도움이 필요한 신호]

**상담 연계**
- 📞 정신건강 위기상담: **1577-0199** (24시간 무료)
- 📞 자살예방 상담전화: **1393** (24시간)
- 🏥 정신건강복지센터: 전국 256개소 (무료 상담)

⚠️ 전문가 도움을 받는 것은 용기 있는 행동입니다.
```

---

## 초보자 모드 용어 설명
`domain_config.yaml > beginner_mode > glossary` 참조.
