# 인텐트 라우터 (10개 모드)

> 공통 분류 규칙: [`../../common/intent_router_base.md`](../../common/intent_router_base.md)

## ⚠️ 응급 우선 규칙 (모든 인텐트보다 우선)

아래 키워드 감지 시 **인텐트 분류 전에** 즉시 응급 안내 출력:
`흉통` / `호흡 곤란` / `의식 저하·상실` / `마비` / `심한 출혈` / `경련·발작` / `39°C 이상 + 경련`

```markdown
🚨 **응급 상황일 수 있습니다**
→ 즉시 **119**에 전화하세요.
응급처치가 필요하면 119 상담원이 안내해드립니다.
```

---

## 분류 규칙 (공통)
사용자 요청을 아래 10개 인텐트 중 하나로 분류한다.
파라미터 부족 시 1회 질문. 추측 가능하면 추측 후 명시.

---

## 인텐트 목록

### 1. Symptom Check (증상 확인)
- **표현:** "머리가 너무 아파", "어디 가야 해?", "무슨 과 가야 해?", "열이 나는데"
- **산출물:** 증상 분석 → 의심 질환 범위 → 진료과 추천 → 병원 연계
- **최소 데이터:** 증상 부위 또는 증상 설명
- **깊이:** Flash (병원 연계는 hira-hospital 스킬 호출)
- **주의:** 진단 단정 금지 — "~일 수 있습니다" 표현 사용

### 2. Find Hospital (병원 찾기)
- **표현:** "근처 병원 찾아줘", "이비인후과 어디 있어?", "응급실 어디야?"
- **산출물:** hira-hospital 스킬 호출 → 병원 목록 + 운영시간
- **최소 데이터:** 지역 또는 진료과
- **깊이:** Flash only
- **처리:** hira-hospital 스킬로 위임

### 3. Disease Info (질환 정보)
- **표현:** "당뇨가 뭐야?", "고혈압 원인", "암 초기 증상", "이 병 치료법"
- **산출물:** 질환 개요 + 원인 + 증상 + 치료 + 예방 Flash
- **최소 데이터:** 질환명
- **깊이:** Flash + Deep-Dive 요청 시
- **데이터:** 국가건강정보포털 API → 미승인 시 web_search

### 4. Drug Info (의약품 정보)
- **표현:** "타이레놀 용법", "이 약 뭐야?", "부작용 뭐야?", "같이 먹으면 안 되는 약"
- **산출물:** 효능 + 용법·용량 + 부작용 + 주의사항 + 병용금기
- **최소 데이터:** 약 이름 (성분명 또는 상품명)
- **깊이:** Flash + Deep-Dive 요청 시
- **데이터:** 식약처 의약품개요정보 API → 미승인 시 web_search

### 5. Emergency Guide (응급 판단)
- **표현:** "응급인지 모르겠어", "119 불러야 해?", "지금 응급실 가야 해?", "위험한 증상인가?"
- **산출물:** 응급/비응급 판단 기준 + 즉시 행동 지침
- **최소 데이터:** 증상 설명
- **깊이:** Flash only
- **주의:** 불확실하면 무조건 응급 쪽으로 판단

### 6. Health Checkup (건강검진)
- **표현:** "건강검진 언제 받아?", "국가검진 대상이야?", "암검진 어떻게 받아?"
- **산출물:** 검진 종류·대상·주기·무료 검진 안내
- **최소 데이터:** 없음 (나이 있으면 맞춤형)
- **깊이:** Flash + Deep-Dive 요청 시

### 7. Vaccination (예방접종)
- **표현:** "독감 예방접종 언제?", "필수 백신 뭐야?", "성인 예방접종", "아이 접종 일정"
- **산출물:** 접종 종류·대상·시기·장소 Flash
- **최소 데이터:** 없음 (연령·상황 있으면 맞춤형)
- **깊이:** Flash + Deep-Dive 요청 시

### 8. Healthy Living (건강 생활)
- **표현:** "혈압 낮추는 법", "건강한 식단", "운동 추천", "금연하고 싶어", "수면 개선"
- **산출물:** 생활습관 개선 가이드 Flash
- **최소 데이터:** 없음
- **깊이:** Flash + Deep-Dive 요청 시

### 9. Mental Health (정신건강)
- **표현:** "번아웃인 것 같아", "너무 우울해", "불안 증상", "수면 장애", "스트레스 심해"
- **산출물:** 자가 체크 + 대처법 + 전문 상담 연계 (정신건강 위기상담 1577-0199)
- **최소 데이터:** 없음
- **깊이:** Flash + Deep-Dive 요청 시
- **주의:** 자해·자살 언급 시 즉시 위기상담 안내 (1393, 24시간)

### 10. Beginner Guide (입문)
- **표현:** "진료과 뭐가 있어?", "병원 처음인데", "의료보험 어떻게 써?", "실비 청구 방법"
- **산출물:** 한국 의료 시스템 입문 Flash (초보자 모드 강제)
- **최소 데이터:** 없음
- **깊이:** Flash only

---

## 공통 인텐트

### 🔰 Beginner Mode 자동 전환
키워드: "쉽게", "기초", "처음인데"

### ❓ Scope Out
의료 외 질문 → 안내
예: "약국 위치" → hira-hospital (약국 검색 가능)
예: "의료 사고 소송" → legal-counsel 스킬 안내
