# 의료/건강 플레이북

> 공통 Phase 구조: [`../common/playbook_base.md`](../common/playbook_base.md)

---

## ⚠️ Phase 0: 응급 사전 스크리닝 (모든 Phase 전에 실행)

`domain_config.yaml > emergency_keywords` 목록 대조:
- **감지됨** → 즉시 아래 출력 후 종료:
  ```
  🚨 응급 상황일 수 있습니다. 즉시 119에 전화하세요.
  119 상담원이 응급처치를 안내해드립니다.
  ```
- **자해·자살 언급** → 즉시:
  ```
  힘드시겠어요. 지금 바로 1393(자살예방상담전화, 24시간)에 전화해주세요.
  ```

---

## Phase 1: 인텐트 분류 & 파라미터 확인

1. 사용자 요청을 [`references/intent_router.md`](references/intent_router.md)로 분류
2. **초보자 모드 감지**: "쉽게", "처음인데" 키워드
3. 필수 파라미터:
   - **Symptom Check**: 증상 부위/설명
   - **Find Hospital**: 지역 + 진료과
   - **Disease Info**: 질환명
   - **Drug Info**: 약 이름
4. 파라미터 부족 시:
   ```
   예: "어떤 증상이 있으신가요? (통증 부위, 언제부터, 다른 증상)"
   예: "어떤 약인지 알려주시면 정보를 찾아드릴게요"
   ```

---

## Phase 2: 데이터 수집

### 2-1. 병원 찾기 → hira-hospital 스킬 위임
```bash
bash skills/hira-hospital/scripts/hospital_search.sh "[지역]" "[진료과]"
```

### 2-2. 질환/증상 정보 → 국가건강정보포털 API
```bash
# 키 승인 후 활성화
# bash skills/health-guide/scripts/kdca_health.sh "[질환명]"
# 미승인 시: web_search 대체
```
```
web_search: "[질환명] 국가건강정보포털"
web_search: "질병관리청 [증상] 정보"
```

### 2-3. 의약품 정보 → 식약처 API
```bash
# 키 승인 후 활성화
# bash skills/health-guide/scripts/drug_info.sh "[약품명]"
# 미승인 시: web_search 대체
```
```
web_search: "[약품명] 식약처 e약은요"
web_search: "[약품명] 용법 부작용 공식"
```

### 2-4. API 폴백 전략
| 상황 | 대체 방법 |
|------|---------|
| 국가건강정보포털 미승인 | web_search: 질병관리청 검색 |
| 식약처 API 미승인 | web_search: e약은요 검색 |
| API 타임아웃 | web_search 즉시 대체, "웹 검색 기반" 명시 |

---

## Phase 3: 분석

### 증상 → 진료과 매핑 (내장 레퍼런스)

| 증상 부위/종류 | 1차 추천 진료과 | 주의 신호 (응급) |
|--------------|--------------|----------------|
| 두통 | 내과 / 신경과 | 갑작스러운 극심한 두통, 의식 저하 → 🚨 |
| 흉통 | 내과 / 심장내과 | 압박감·방사통·식은땀 → 🚨 |
| 복통 | 내과 / 외과 | 극심한 통증·경직·발열 → 🚨 |
| 호흡 곤란 | 내과 / 호흡기내과 | 갑작스러운 호흡 불가 → 🚨 |
| 관절·근육통 | 정형외과 / 류마티스내과 | |
| 피부 이상 | 피부과 | 급격한 부종·발진·호흡 곤란 → 🚨 |
| 눈 이상 | 안과 | 갑작스러운 시력 상실 → 🚨 |
| 귀·코·목 | 이비인후과 | |
| 소아 발열 | 소아청소년과 | 38.5°C↑ + 경련 → 🚨 |
| 정신·감정 | 정신건강의학과 | 자해·자살 언급 → 즉시 1393 |
| 여성 생식기 | 산부인과 | |
| 비뇨기 | 비뇨의학과 | |
| 치아·잇몸 | 치과 | |

### 국가건강검진 대상 판단
- 짝수 년도: 짝수 출생연도 or 의료급여수급자
- 홀수 년도: 홀수 출생연도
- 국민건강보험공단 1577-1000 또는 앱에서 확인

### 성인 예방접종 권장 일정 (질병관리청 기준)
| 백신 | 대상 | 주기 |
|------|------|------|
| 인플루엔자(독감) | 전 연령 | 매년 (10~11월 권장) |
| 폐렴구균 | 65세↑ | 1회 (PCV13) + 1회 (PPSV23) |
| 파상풍·디프테리아 | 성인 | 10년마다 |
| 대상포진 | 60세↑ | 1회 |
| A형 간염 | 2세↑ (미접종자) | 2회 |
| B형 간염 | 미접종자 | 3회 |

---

## Phase 4: 출력

[`references/output_templates.md`](references/output_templates.md) 템플릿 적용.

### 면책 문구 (모든 응답 필수)
> ⚠️ 본 내용은 일반 건강 정보이며, 의학적 진단·처방이 아닙니다.
> 증상이 지속되거나 악화되면 반드시 의사 진료를 받으세요.
> **응급 시 즉시 119** | 정신건강 위기 1393 | 의료상담 1339

---

## API 스크립트 (키 승인 후 활성화)

```bash
# scripts/kdca_health.sh — 국가건강정보포털 질환 검색
# 키 위치: ~/.config/kdca/api_key (승인 후 저장)

# scripts/drug_info.sh — 식약처 의약품개요정보
# 키 위치: ~/.config/data-go-kr/api_key (활용신청 완료)
```

> 스크립트는 키 승인 후 CHM-237 후속 작업으로 추가 예정
