# 虚拟列表/滚动加载选择框处理指南

## 概述

本系统中多个下拉选择框使用虚拟列表（Virtual List）或滚动加载技术来优化性能，**这不仅限于学期选择，还包括但不限于**：
- 学校名称选择
- 课程选择
- 班级选择
- 员工/负责人选择
- 其他数据量较大的选择项

## 识别特征

- 下拉框初始只显示 5-10 个选项
- 有滚动条但滚动时动态加载更多数据
- 使用 `rc-virtual-list` 或类似的虚拟滚动组件
- 快速滚动时可能出现空白占位

## 处理原则

### 1. 不要仅根据初始显示判断

- 初始显示的选项只是全部数据的一小部分
- 用户指定的选项可能在滚动后才加载

### 2. 获取完整列表的方法

根据实际情况选择合适的方法：

#### 滚动触发加载
- 找到滚动容器，向下滚动到底部触发加载
- 然后收集所有选项

#### 关键词搜索
- 如果下拉框支持输入过滤，尝试输入关键词快速定位
- 例如输入"2026"查找2026年的学期

#### 接口数据分析
- 查看网络请求，从 API 响应中获取完整数据列表
- 这通常是最可靠的方法

#### 输入框直接填写
- 某些下拉框允许直接输入值，可以绕过选择

### 3. 与用户沟通

- 如果找不到用户指定的选项，先确认是否已经获取了完整列表
- 告知用户系统使用滚动加载，可能需要一些操作才能看到全部选项
- 提供已找到的可用选项供用户选择

### 4. 验证选项可用性

- 部分选项可能置灰（disabled），需要检查是否可选
- 确认选项的文本匹配（注意空格、全角半角等）

## 具体场景处理

### 场景1：学期选择

**问题**：用户要找"2026年暑假"，但初始列表只显示到"2026年春季"

**解决步骤**：
1. 分析下拉框结构，找到滚动容器
2. 向下滚动触发加载更多选项
3. 继续滚动直到看到"2026年暑假"或确认列表已加载完毕
4. 如果找到，检查是否置灰
5. 如果未找到，告知用户该学期不存在

### 场景2：学校名称搜索

**问题**：搜索学校名称后下拉框显示结果

**解决步骤**：
1. 输入关键词触发搜索
2. 观察搜索结果数量
3. 如果结果较多，可能需要滚动查看全部
4. 让用户确认目标学校是否在列表中

### 场景3：负责人选择

**问题**：需要选择某个员工作为负责人

**解决步骤**：
1. 点击负责人下拉框
2. 输入员工姓名关键词搜索
3. 如果支持，直接输入完整姓名
4. 从结果中选择匹配的员工

## 技术实现参考

### 虚拟列表的工作原理

```
可视区域（显示 5-10 项）
┌─────────────────┐
│ 选项 1          │
│ 选项 2          │
│ 选项 3          │ ← 当前可见
│ 选项 4          │
│ 选项 5          │
└─────────────────┘
     ↓ 滚动
加载更多数据...
     ↓
┌─────────────────┐
│ 选项 6          │
│ 选项 7          │ ← 新加载的
│ 选项 8          │
│ ...             │
└─────────────────┘
```

### 如何判断是虚拟列表

1. 下拉框有滚动条但初始内容很少
2. 滚动时内容动态变化
3. DOM 结构中可能包含 `rc-virtual-list` 相关类名
4. 网络面板显示滚动时触发新的数据请求

## 最佳实践总结

1. **永远假设有更多数据** - 不要仅凭初始显示下结论
2. **优先使用搜索** - 如果下拉框支持输入过滤，用它快速定位
3. **必要时滚动加载** - 找到滚动容器，触发加载更多
4. **确认后再报告** - 在确认已获取完整列表前，不要说选项不存在
5. **灵活应对** - 不同下拉框可能有不同的交互方式，根据实际情况调整策略
