# 新建需求单详细流程

## 流程概述

创建需求单采用"先尝试操作，需要登录再询问"的策略，并一次性收集所需信息，按顺序填写。

## 完整操作流程

### 第一步：打开新建弹窗

1. 访问需求单列表页面 `/xiaonei-web/sales/clue`
2. **尝试直接操作**：直接点击"新建需求单"按钮
   - 如果系统已登录，弹窗正常打开，继续下一步
   - 如果跳转登录页面，告知用户需要登录，并执行"登录流程"

### 第二步：打开新建弹窗并动态获取表单选项

1. 点击"新建需求单"按钮打开弹窗
2. **动态获取可选值**：
   - 先点击各下拉框/单选框查看页面实际提供的选项
   - **不要预设写死的选项值**，因为选项可能随版本迭代而变化
   - 将获取到的可选值展示给用户选择

### 第三步：收集必要信息并填写

根据弹窗中实际的必填项，向用户收集信息（按页面展示顺序）：

| 信息项 | 是否必填 | 说明 |
|--------|----------|------|
| **学校名称** | ✅ 必填 | 搜索关键词，从结果中选择 |
| **学期** | ✅ 必填 | 选择学校后才可获取；已创建会置灰不可选 |
| **学校拓展模式** | ✅ 必填 | 单选，选项以页面展示为准 |
| **其他字段** | 视页面而定 | 根据实际弹窗中的必填项收集 |

**填写顺序（重要）**：
1. **选择学校** → 输入关键词搜索 → 选择学校
2. **选择学期** → 下拉框会加载该校可用学期（已创建会置灰）
3. **选择学校拓展模式** → 根据页面展示的单选项选择
4. **点击"确定"** → 进入详情页

## 学期选择优化策略（关键步骤）

学期选择是创建需求单的关键步骤，下拉框默认只显示部分选项，**务必获取完整列表后再做判断**。

### ⚠️ 问题本质

- 学期下拉框使用虚拟列表/滚动加载技术，默认仅显示 5-8 个选项
- **更多学期需要向下滚动或滚动加载才能看到**
- 如果用户指定的学期未在初始视图中显示，**不要直接说学期不存在**

### 解决策略

#### 1. 分析下拉框行为

- 点击学期下拉框后，先观察下拉框的滚动行为
- 判断是否支持滚动加载（通常有滚动条或可以向下滚动）
- 分析页面结构，找到合适的操作方式

#### 2. 获取完整学期列表的方法

根据下拉框类型，选择合适的方法：

**方法A：滚动下拉框**
- 找到下拉框的滚动容器
- 向下滚动到底部，触发加载更多选项
- 然后获取所有可见选项

**方法B：使用搜索/过滤功能**
- 有些下拉框支持输入关键词过滤
- 尝试输入学期名称（如"2026"）快速定位

**方法C：分析接口数据**（如果网络请求可见）
- 查看获取学期列表的 API 响应
- 从接口数据中获取完整列表

#### 3. 处理用户指定学期的情况

如果用户提前指定了目标学期（如"2026年暑假"）：
- ✅ **先获取完整列表**，然后在列表中查找匹配项
- ✅ 如果找到匹配项且未置灰，直接选择
- ✅ 如果找到但已置灰（显示"已创建"），告知用户该学期已有需求单
- ❌ **不要仅根据初始显示的选项就判断学期不存在**

#### 4. 智能推荐学期

获取完整列表后，按以下优先级向用户推荐：
- **首选**：平台当前学期（标记为"当前学期"的选项）
- **次选**：当前学期之后的2个可用学期（排除已创建的）

#### 5. 学期列表解读

- **"当前学期"** - 平台当前激活的学期，通常是首选
- **"已创建"** - 该学校在此学期已有需求单，不可重复创建
- **无标记** - 可用学期，可以创建新需求单

### 第四步：在详情页添加收费服务项

1. 进入详情页后，找到"收费服务项"区域
2. **动态查看可用服务类型**：
   - 页面会展示当前可用的服务选项（如派师、双师等）
   - **不要预设服务类型**，以页面实际展示为准
3. 根据用户需求选择对应的服务项并配置详情

### 第五步：填写其他信息并保存

1. **填写其他信息**
   - 基础信息 Tab：联系人、需求详情
   - 教务支持 Tab：配置教务相关信息
   - 其他信息 Tab：备注、附件

2. **保存或提交**
   - 点击"保存"暂存草稿
   - 或点击"提交审核"直接提交

## 表单填写注意事项

### 为什么有时看不到学期？

- 学期列表需要在选择学校后才会加载
- 如果先点击学期下拉，会显示"暂无数据"

### 学期下拉框显示不完整的问题（关键）

- **问题本质**：学期下拉框使用虚拟列表/滚动加载技术，默认只显示部分选项（通常5-8个）
- 更多学期需要**向下滚动触发加载**才能看到
- **正确做法**：
  1. 分析下拉框的滚动容器和加载机制
  2. 通过滚动或其他方式获取完整选项列表
  3. 在完整列表中查找目标学期
- **错误做法**：仅根据页面初始显示的选项就告知用户学期不存在，而不尝试获取完整列表

### 已创建学期置灰规则

- 如果该学校在某学期已创建过需求单，该学期选项会显示"已创建"并置灰不可选
- 此时应去列表页搜索该需求单，而不是重复创建

### 动态获取选项值

- 所有下拉框、单选框的选项值都应从页面动态获取
- 不要依赖预设的选项值，因为系统可能迭代更新
- 如遇到未知的选项，向用户确认后再选择

### 学期选择最佳实践

1. **提前获取候选列表**：在打开新建弹窗前，可以从需求单列表页的"学期"筛选项中获取完整学期列表作为参考
2. **必做步骤**：选择学校后，**立即分析下拉框结构并获取完整学期列表**，不要仅依赖下拉框初始显示的内容
3. **灵活处理**：根据页面实际情况选择合适的方法（滚动加载、搜索过滤、接口分析等）获取完整选项
4. **推荐策略**：向用户展示当前学期及后续2个可用学期供快速选择
5. **确认机制**：当用户指定学期名称时，先在获取到的完整列表中查找匹配项，确认存在且未置灰后再选择，**切勿因初始列表无显示就判定学期不存在**
