# 需求单列表页面详细操作

## 页面地址

**路径**：`/xiaonei-web/sales/clue`

**完整 URL 示例**：
- 正式环境：`https://xiaonei.haoduo.vip/xiaonei-web/sales/clue`
- 开发环境：`https://xiaonei-dev.haoduo.vip/xiaonei-web/sales/clue`
- QA 环境：`https://xiaonei-qa.haoduo.vip/xiaonei-web/sales/clue`
- 预发环境：`https://xiaonei-pre.haoduo.vip/xiaonei-web/sales/clue`

## 页面布局

### Tab 切换

页面分为两个 Tab：
- **全部**：显示所有有权限查看的需求单
- **待审核**：显示需要当前用户审核的需求单（带 Badge 角标显示数量）

### 搜索筛选区域

页面顶部提供多个筛选条件（根据 Tab 和权限可能有所不同）：

**基础筛选条件**：

| 筛选条件 | 输入类型 | 说明 |
|----------|----------|------|
| 学校名称 | 下拉搜索框 | 支持输入学校名称搜索 |
| 需求单ID | 数字输入框 | 精确搜索 |
| 审核状态 | 下拉选择 | 未提交、审核中、已通过、已驳回等 |
| 学期 | 下拉选择 | 平台学期列表，支持搜索 |
| 收费服务项 | 多选下拉 | 双师课堂、派师授课等 |

**其他筛选条件**（根据 Tab 和权限显示）：

| 筛选条件 | 输入类型 | 说明 |
|----------|----------|------|
| 所需支持项 | 多选下拉 | 各种支持服务类型 |
| 学校等级 | 下拉选择 | 各类学校等级标签 |
| 首次开课时间 | 日期范围 | 开始日期-结束日期 |
| 需求单状态 | 多选下拉 | 正常、已关闭等状态 |
| 省市区 | 树形选择 | 行政区划选择 |
| 负责人 | 搜索选择 | 输入姓名搜索员工 |
| 是否有高级教务 | 下拉选择 | 是/否 |
| 高级教务 | 搜索选择 | 输入姓名搜索 |
| 过滤测试学校 | 下拉选择 | 是/否 |
| 合作伙伴 | 搜索选择 | 输入合作伙伴名称搜索 |
| 对账状态 | 下拉选择 | 未对账、对账中、已对账 |

## ⚠️ 预置筛选项提醒

页面存在预置的默认筛选条件，操作前请注意检查：

| 预置筛选项 | 默认值 | 影响 |
|-----------|--------|------|
| 学期 | 平台当前学期 | 仅显示当前学期的需求单 |
| 需求单状态 | 进行中、已完成 | 可能过滤掉已关闭的需求单 |
| 过滤测试学校 | 是 | 过滤掉测试学校数据 |

> 根据具体需求，决定是否需要调整或清除这些预置筛选项

## 学期列表数据说明

页面加载时会请求接口获取学期列表：

- **接口**：`GET api/v1/haoduo-service/school/platform-semester/query-platform-semester-list`
- **排序规则**：
  - `sort`：按时间顺序排序（从小到大，由早到晚）
  - `displaySort`：用于展示顺序
- **字段说明**：
  - `name`：学期名称（如"2026年春季"）
  - `id`：学期ID
  - `currentSemester`：`true` 表示平台当前学期

## 列表表格列

| 列名 | 说明 |
|------|------|
| 需求单ID | 需求单唯一标识 |
| 名称 | 学校名称，下方显示省市区信息 |
| 学期 | 所属平台学期，下方显示需求单关闭状态 |
| 审核状态 | 当前审核状态，驳回状态可查看驳回原因 |
| 高级教务 | 负责的高级教务姓名 |
| 首次开课时间 | 学校预计首次开课日期 |
| 收费服务项 | 该需求单包含的收费服务类型 |
| 所需支持项 | 需要的支持服务类型 |
| 合作伙伴合作记录 | 关联的合作伙伴记录 |
| 对账状态 | 未对账/对账中/已对账，可操作发起对账 |
| 教育局 | 所属教育局名称 |
| 负责人 | 需求单负责人及部门，如已离职会标注 |
| 需求单创建人 | 创建人姓名及ID |
| 创建时间 | 需求单创建时间 |
| 更新时间 | 需求单最后更新时间 |
| 操作 | 查看、编辑等操作按钮 |

## 页面操作按钮

- **新建需求单**：打开新建弹窗
- **批量新建需求单**：批量创建需求单
- **批量更换负责人**：批量修改需求单负责人（需权限）
- **批量导入其他费用项**：导入额外费用（需权限）
- **导出**：导出列表数据（需权限）
- **展开/收起学校**：展开显示更多学校选择

## 进入详情

- 点击需求单ID 或操作列的"查看"按钮，进入详情页
- URL 格式：`/xiaonei-web/sales/clue/detail/:id`

## 搜索需求单操作步骤

1. **访问需求单列表页面**：导航到 `/xiaonei-web/sales/clue`
   - 如需要登录，执行登录流程
2. **设置筛选条件**：在顶部搜索区域选择筛选条件：
   - 输入需求单ID进行精确搜索
   - 选择审核状态筛选
   - 选择学期筛选（默认当前学期）
   - 选择收费服务项等多选条件
3. 点击"搜索"按钮执行搜索
4. 查看筛选后的结果列表
