# 需求单详情页面详细操作

## 页面地址

**路径**：`/xiaonei-web/sales/clue/detail/:id`

**完整 URL 示例**：
- 正式环境：`https://xiaonei.haoduo.vip/xiaonei-web/sales/clue/detail/12345`
- 开发环境：`https://xiaonei-dev.haoduo.vip/xiaonei-web/sales/clue/detail/12345`
- QA 环境：`https://xiaonei-qa.haoduo.vip/xiaonei-web/sales/clue/detail/12345`

## 页面布局

页面采用卡片式布局，从上到下分为：

1. **顶部操作栏**：需求单标题、状态标签、主要操作按钮
2. **驳回原因提示**（如被驳回）：显示驳回原因
3. **内容区域**：多个 Tab 展示不同信息

## 页面头部信息

- 需求单ID
- 学校名称及标签
- 当前审核状态（带颜色标识）
- 需求单来源标识
- 各类状态标签（交付状态、采购状态等）

## 操作按钮

根据状态和权限显示不同的操作按钮：

| 按钮 | 说明 | 权限要求 |
|------|------|----------|
| **编辑** | 编辑需求单信息 | 负责人权限，且状态为"未提交"或"已驳回" |
| **提交/提交审核** | 提交需求单进行审核 | 负责人权限，且状态为"未提交"或"已驳回" |
| **通过** | 审核通过需求单 | 审核人权限，且状态为"审核中" |
| **驳回** | 驳回需求单并填写原因 | 审核人权限，且状态为"审核中" |
| **关闭** | 关闭需求单 | 负责人权限 |
| **转移** | 转移需求单给其他人 | 负责人权限 |
| **生成方案链接** | 生成分享链接 | 视权限而定 |
| **操作日志** | 查看操作历史 | 所有人 |
| **返回列表** | 返回需求单列表 | 所有人 |

## 主要内容区域 Tab

通常包含以下标签页：

- **基础信息**：学校信息、联系人、需求详情
- **派师授课**：派师课程班级信息
- **双师课堂**：双师课程班级信息
- **教务支持**：教务相关配置
- **其他信息**：备注、附件等

## 审核状态流转

```
┌─────────┐    提交     ┌─────────┐   通过    ┌─────────┐
│ 未提交  │ ─────────> │ 审核中  │ ───────> │ 已通过  │
└─────────┘             └─────────┘           └─────────┘
     │                      │
     │                      │ 驳回
     ▼                      ▼
┌─────────┐            ┌─────────┐
│ 可编辑  │<───────────│ 已驳回  │
└─────────┘   编辑后   └─────────┘
              重新提交
```

1. **未提交**：初始状态，可编辑和提交
2. **审核中**：已提交待审核，不可编辑
3. **已通过**：审核通过，进入交付流程
4. **已驳回**：审核被驳回，可查看原因后重新编辑提交

## 注意事项

- 不同审核状态下可执行的操作不同
- 部分操作需要特定权限
- 编辑后需重新提交审核
- 详情页数据会实时刷新

## 查看需求单详情操作步骤

1. **访问详情页面**：直接导航到 `https://xiaonei.haoduo.vip/xiaonei-web/sales/clue/detail/:id`
   - 如需要登录，执行登录流程，完成后自动进入详情页
2. 查看需求单完整信息：
   - 顶部头部信息（状态、操作按钮）
   - 各 Tab 页的内容（基础信息、课程班级等）

**替代方式**：
- 从需求单列表中找到目标需求单，点击需求单ID 或操作列的"查看"链接进入详情页

## 编辑需求单操作步骤

1. **进入需求单详情页面**：访问 `/xiaonei-web/sales/clue/detail/:id`
   - 如需要登录，执行登录流程
2. 确认需求单状态为"未提交"或"已驳回"（只有这两种状态可编辑）
3. 点击"编辑"按钮
4. 在编辑界面修改需求单内容：
   - 修改学校信息
   - 调整收费服务项
   - 更新课程班级配置
   - 修改联系人信息等
5. 点击"保存"保存修改
6. 系统提示保存成功

## 提交需求单审核操作步骤

1. **进入需求单详情页面**：访问 `/xiaonei-web/sales/clue/detail/:id`
   - 如需要登录，执行登录流程
2. 确认需求单处于可提交状态
3. 点击"提交"或"提交审核"按钮
4. 如系统有校验提示，按提示完善必填项
5. 确认提交后，需求单状态变为"审核中"
6. 等待审核人处理

## 审核需求单操作步骤（审核人权限）

1. **进入待审核页面**：访问 `/xiaonei-web/sales/clue` 并切换到"待审核"Tab
   - 或直接访问具体需求单详情页 `/xiaonei-web/sales/clue/detail/:id`
   - 如需要登录，执行登录流程
2. 查看需求单内容，确认是否符合要求
3. 如通过，点击"通过"按钮确认
4. 如驳回，点击"驳回"按钮并填写驳回原因
5. 审核结果会通知需求单负责人

## 关闭需求单操作步骤

1. **进入需求单详情页面**：访问 `/xiaonei-web/sales/clue/detail/:id`
   - 如需要登录，执行登录流程
2. 确认需求单可以关闭（无进行中业务）
3. 点击"关闭"按钮
4. 选择关闭原因类型
5. 填写关闭说明（如需）
6. 确认关闭后，需求单状态变为已关闭
