---
name: sales-clue
description: 后台系统/运营平台/销售系统的需求单操作指南。当用户提到需求单、线索管理、审核需求单，或需要登录后台/运营端/平台端（xiaonei-web）处理学校需求时，必须使用此技能。包含完整的 CAS 统一登录平台登录流程、需求单列表页和详情页操作、审核状态流转等。适用于 haoduo.vip 域名下的运营管理系统。
license: UNLICENSED
metadata:
  author: user
  version: "2.0.0"
---

# 销售需求单（用户维度）操作指南

## 触发条件

**当用户提到以下任何内容时，必须使用此技能：**

- 需求单、销售需求单、线索管理
- 查看/创建/编辑/提交需求单
- 审核需求单、待审核列表
- 登录后台、运营端、平台端、销售系统
- xiaonei-web、haoduo.vip、CAS 登录平台
- 学校需求、客户线索

**系统别名说明：**
- 后台 / 后台系统
- 运营端 / 运营平台
- 平台端 / 管理系统
- 销售系统 / xiaonei-web
- 小内 / 校内的 web 端

## 环境说明

| 环境 | 域名 | 访问限制 |
|------|------|----------|
| 开发环境 | https://xiaonei-dev.haoduo.vip/ | 仅限公司内网访问 |
| QA 环境 | https://xiaonei-qa.haoduo.vip/ | 仅限公司内网访问 |
| 预发/灰发环境 | https://xiaonei-pre.haoduo.vip/ | 仅限公司内网访问 |
| 正式环境 | https://xiaonei.haoduo.vip/ | 无限制（**默认环境**）|

**重要规则**：
- **默认使用正式环境**，无需询问用户想要使用哪个环境
- 仅当用户**主动提出**需要其他环境时，才使用对应的环境

## 核心原则：先尝试，再询问

**不要一上来就问手机号！**

1. **先尝试直接操作**：用户可能仍处于登录状态，直接执行目标操作
2. **按需登录**：只有遇到登录页面或权限不足时，才进入登录流程
3. **避免冗余询问**：不要预设需要登录，让系统状态决定是否询问

### 执行步骤

**第一步：直接访问目标页面**
- **默认使用正式环境**：直接导航到目标页面 URL
- 示例页面：
  - 需求单列表：`/xiaonei-web/sales/clue`
  - 需求单详情：`/xiaonei-web/sales/clue/detail/:id`

**第二步：检查页面状态**

| 状态 | 页面表现 | 处理方式 |
|------|----------|----------|
| ✅ **已登录** | 正常显示页面内容，可进行操作 | **直接执行用户请求的操作** |
| ❌ **未登录** | 跳转到 CAS 登录页 | **执行登录流程**（见下方） |
| ⚠️ **登录过期** | 操作过程中突然跳转登录页 | **执行登录流程，完成后继续原操作** |

**第三步：登录流程（仅在需要时执行）**

1. **获取手机号** - 询问用户："需要登录系统，请提供您的手机号"
2. **填写手机号** - 填入手机号输入框
3. **发送验证码** - 点击"发送验证码"按钮
4. **获取并填写验证码** - 询问用户短信验证码并填入
5. **完成登录** - 点击"登录"按钮，成功后自动跳转回原页面

> ⚠️ **警告**：验证码连续错误会导致账号锁定，务必获取正确的手机号

## 主要页面

### 1. 需求单列表页面

**页面地址**：`/xiaonei-web/sales/clue`

**页面布局**：
- 两个 Tab："全部"和"待审核"（带 Badge 角标显示数量）
- 顶部搜索筛选区域
- 列表表格

**关键筛选项**（注意预置默认值）：
| 筛选项 | 默认值 | 影响 |
|--------|--------|------|
| 学期 | 平台当前学期 | 仅显示当前学期的需求单 |
| 需求单状态 | 进行中、已完成 | 可能过滤掉已关闭的需求单 |
| 过滤测试学校 | 是 | 过滤掉测试学校数据 |

**学期列表数据说明**：
- **接口**：`GET api/v1/haoduo-service/school/platform-semester/query-platform-semester-list`
- **排序规则**：`sort` 按时间顺序，`displaySort` 用于展示
- **字段**：`name`（学期名称）、`id`（学期ID）、`currentSemester`（当前学期标记）

**进入详情**：点击需求单ID 或操作列的"查看"按钮

**详细操作说明**：见 `references/clue-list-page.md`

### 2. 需求单详情页面

**页面地址**：`/xiaonei-web/sales/clue/detail/:id`

**页面布局**：
1. **顶部操作栏**：需求单标题、状态标签、主要操作按钮
2. **驳回原因提示**（如被驳回）
3. **内容区域**：多个 Tab 展示不同信息

**操作按钮**（根据状态和权限显示）：
- **编辑**：编辑需求单信息
- **提交/提交审核**：提交需求单进行审核
- **通过**：审核通过需求单（审核人权限）
- **驳回**：驳回需求单并填写原因（审核人权限）
- **关闭**：关闭需求单

**审核状态流转**：
1. **未提交** → 2. **审核中** → 3. **已通过** / 4. **已驳回**

**详细操作说明**：见 `references/clue-detail-page.md`

## 常见操作流程概览

### 查看需求单列表
1. 直接访问 `https://xiaonei.haoduo.vip/xiaonei-web/sales/clue`
2. 如需要登录，执行登录流程
3. 查看列表数据

### 查看需求单详情
1. 直接访问 `https://xiaonei.haoduo.vip/xiaonei-web/sales/clue/detail/:id`
2. 如需要登录，执行登录流程
3. 查看详情信息

### 编辑需求单
1. 进入详情页面
2. 确认状态为"未提交"或"已驳回"
3. 点击"编辑"按钮，修改内容后保存

### 提交审核
1. 进入详情页面
2. 确认处于可提交状态
3. 点击"提交"或"提交审核"按钮

### 审核需求单（审核人权限）
1. 进入待审核页面或详情页
2. 查看内容后点击"通过"或"驳回"

### 新建需求单

**流程概述**：
1. 访问列表页，点击"新建需求单"
2. **动态获取表单选项**（不要预设写死的值）
3. 收集信息并填写：学校 → 学期 → 学校拓展模式 → 其他必填项
4. 点击确定，进入详情页添加收费服务项

**⚠️ 学期选择关键要点**：
- 学期下拉框使用虚拟列表，默认只显示部分选项
- **必须先获取完整列表**再判断学期是否存在
- 可通过滚动加载、搜索过滤或接口分析获取完整列表
- 已创建的学期会置灰显示"已创建"

**详细操作说明**：见 `references/create-clue.md`

## 虚拟列表/滚动加载选择框处理

本系统中多个下拉选择框使用虚拟列表技术：
- 学校名称选择
- 学期选择
- 课程/班级选择
- 员工/负责人选择

**识别特征**：
- 下拉框初始只显示 5-10 个选项
- 滚动时动态加载更多数据

**处理原则**：
1. **不要仅根据初始显示判断** - 用户指定的选项可能在滚动后才加载
2. **获取完整列表** - 滚动触发加载、关键词搜索、接口数据分析
3. **确认可用性** - 检查选项是否置灰（disabled）

**详细说明**：见 `references/virtual-list-handling.md`

## 注意事项

### 登录安全
- **验证码连续错误会导致账号锁定！**
- 手机号和验证码必须向用户索取，严禁自行填写测试数据

### 创建需求单
1. **动态获取选项值** - 不要预设写死的选项值，从页面实时获取
2. **信息收集顺序** - 学校 → 学期 → 其他必填项
3. **学期选择** - 务必获取完整列表，滚动查看全部选项
4. **环境选择** - 默认使用正式环境

### 网络与权限
- 开发/QA/灰发环境仅限公司内网访问
- 部分操作需要特定权限，无权限时按钮不可见
- 登录过期后会自动跳转登录页，按流程重新登录即可

## 参考文档

- `references/login-flow.md` - 详细登录流程
- `references/clue-list-page.md` - 需求单列表页详细操作
- `references/clue-detail-page.md` - 需求单详情页详细操作
- `references/create-clue.md` - 创建需求单详细流程
- `references/virtual-list-handling.md` - 虚拟列表选择框处理指南
