# Hardcover Entity Reference

Detailed field documentation for Hardcover GraphQL entities.

## Table of Contents

- [Books](#books)
- [User Books](#user-books)
- [Editions](#editions)
- [Authors](#authors)
- [Contributions](#contributions)
- [Series](#series)
- [Activities](#activities)
- [Reading Journals](#reading-journals)
- [Lists](#lists)
- [Goals](#goals)
- [Tags](#tags)
- [Languages](#languages)
- [Countries](#countries)
- [Publishers](#publishers)
- [Users](#users)

---

## Books

Core book object representing a conceptual work.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `title` | String | Book title |
| `subtitle` | String | Subtitle |
| `description` | String | Summary/blurb |
| `pages` | Int | Page count |
| `release_date` | date | Original pub date |
| `release_year` | Int | Pub year |
| `rating` | numeric | Average rating (0-5) |
| `ratings_count` | Int | Total ratings |
| `reviews_count` | Int | Total reviews |
| `users_count` | Int | Users with book shelved |
| `users_read_count` | Int | Users who finished |
| `editions_count` | Int | Number of editions |
| `slug` | String | URL identifier |

**Relations:** `editions`, `activities`, `contributions`, `featured_book_series`

---

## User Books

Junction between user and books. Tracks library, status, progress.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `user_id` | Int | Your user ID |
| `book_id` | Int | Book ID |
| `status_id` | Int | Reading status (1-6) |
| `rating` | numeric | Your rating (0-5) |
| `review` | String | Your review |
| `reading_format_id` | Int | Physical/ebook/audio |
| `created_at` | timestamptz | Added date |
| `updated_at` | timestamptz | Last update |

**Status IDs:**
- `1` — Want to Read
- `2` — Currently Reading
- `3` — Read
- `4` — Paused
- `5` — Did Not Finish
- `6` — Ignored

**Relations:** `book`, `user_book_reads`

---

## Editions

Specific published version (physical, ebook, audiobook).

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `book_id` | Int | Parent book |
| `title` | String | Edition title |
| `isbn_13` | String | ISBN-13 |
| `isbn_10` | String | ISBN-10 |
| `asin` | String | Amazon ID |
| `pages` | Int | Page count |
| `release_date` | date | Edition pub date |
| `edition_format` | String | hardcover, paperback, ebook, audiobook |
| `audio_seconds` | Int | Audiobook length |
| `publisher_id` | Int | Publisher |
| `language_id` | Int | Language |
| `rating` | numeric | Edition rating |

**Relations:** `book`, `publisher`, `language`, `country`, `contributions`

---

## Authors

Contributors to books.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `name` | String | Display name |
| `name_personal` | String | First name |
| `slug` | String | URL identifier |
| `bio` | String | Biography |
| `born_date` | date | Birth date |
| `death_date` | date | Death date |
| `location` | String | Location |
| `books_count` | Int | Number of books |
| `users_count` | Int | Followers |
| `alternate_names` | jsonb | Pen names |

**Relations:** `contributions`

---

## Contributions

Author-book relationship with role.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `author_id` | Int | Author |
| `book_id` | Int | Book (if book-level) |
| `contributable_type` | String | Book or Edition |
| `contribution` | String | Role |

**Common Roles:** Author, Illustrator, Translator, Narrator, Editor, Cover Artist, Foreword, Afterword

---

## Series

Collection of related books.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `name` | String | Series name |
| `author_id` | Int | Primary author |
| `description` | String | Description |
| `books_count` | Int | Total books |
| `primary_books_count` | Int | Main series only |
| `is_completed` | Boolean | Series finished |
| `slug` | String | URL identifier |

**Relations:** `author`, `books`

---

## Activities

User actions: ratings, reviews, status updates.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `user_id` | Int | User |
| `event` | String | Activity type |
| `book_id` | Int | Associated book |
| `data` | jsonb | Event payload |
| `created_at` | timestamptz | Timestamp |
| `likes_count` | Int | Likes |

**Event Types:** `UserBookActivity`, `ListActivity`, `PromptActivity`, `GoalActivity`

---

## Reading Journals

Progress entries while reading.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `user_id` | Int | Reader |
| `book_id` | Int | Book |
| `edition_id` | Int | Edition |
| `entry` | String | Journal text |
| `event` | String | started, progress, finished |
| `created_at` | timestamp | Entry date |

---

## Lists

User-created book collections.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `user_id` | Int | Creator |
| `name` | String | List name |
| `description` | String | Description |
| `books_count` | Int | Book count |
| `public` | Boolean | Public visibility |
| `ranked` | Boolean | Ranked list |
| `slug` | String | URL identifier |

**Relations:** `list_books`, `user`

---

## Goals

Reading goals (e.g., "30 books in 2024").

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `user_id` | Int | Owner |
| `goal` | Int | Target number |
| `metric` | String | books, pages |
| `progress` | numeric | Current progress |
| `start_date` | date | Start |
| `end_date` | date | End |
| `state` | String | active, completed, failed |

---

## Tags

Genre, mood, theme tags.

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `tag` | String | Tag text |
| `slug` | String | URL identifier |
| `tag_category_id` | Int | Category |
| `count` | Int | Book count |

---

## Languages

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `language` | String | Name |
| `code2` | String | ISO 639-1 |
| `code3` | String | ISO 639-2 |

---

## Countries

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `name` | String | Country name |
| `code2` | String | ISO 2-letter |
| `region` | String | Region |

---

## Publishers

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `name` | String | Name |
| `slug` | String | URL identifier |
| `editions_count` | Int | Editions |
| `parent_id` | Int | Parent (imprints) |

---

## Users

| Field | Type | Description |
|-------|------|-------------|
| `id` | Int | Unique identifier |
| `username` | String | Username |
| `name` | String | Display name |
| `bio` | String | Bio |
| `books_count` | Int | Shelved books |
| `followers_count` | Int | Followers |
| `pro` | Boolean | Pro subscriber |