# TCE-Core Reclassification

Source: Solomon et al., Transplant Cell Ther 2024;30:608.e1-e10

## Background
Standard TCE v3 assigns DPB1 alleles to Groups 1, 2, or 3.
TCE-Core refines Group 3 into **core** and **non-core** subsets.

## Group 3 Core vs Non-Core

### Core G3 alleles (most common)
DPB1*04:01, DPB1*04:02, DPB1*02:01, DPB1*03:01, DPB1*06:01,
DPB1*11:01, DPB1*13:01, DPB1*15:01, DPB1*16:01, DPB1*19:01

### Non-Core G3 alleles
DPB1*02:02, DPB1*05:01, DPB1*09:01, DPB1*10:01, DPB1*14:01,
DPB1*17:01, DPB1*18:01, DPB1*20:01, DPB1*23:01

## Reclassification Rules

1. If TCE v3 = "Permissive" and one allele is G3 non-core mismatched
   with a G3 core allele → reclassify as **C-NPMM (Core-Nonpermissive Mismatch)**

2. Direction matters:
   - GVH nonpermissive or bidirectional → **nonpermissive** (protective, HR 0.72)
   - HVG-only nonpermissive → remains **permissive** (HR 1.0)

3. If both alleles are in the same core/non-core subset → no change

## Clinical Impact (Solomon 2024)
- OS difference: TCE-Core Δ 18.3% vs TCE-3 Δ 12.7%
- DFS difference: TCE-Core Δ 16.5% vs TCE-3 Δ 8.5%
- 73/136 standard-permissive pairs reclassified as C-NPMM

## Example
Patient: DPB1*04:02 (G3 core) / DPB1*17:01 (G3 non-core)
Donor:   DPB1*02:02 (G3 non-core) / DPB1*05:01 (G3 non-core)

TCE v3: Permissive
TCE-Core: Check if G3 non-core vs G3 core mismatch exists → DPB1*05:01
(non-core) vs DPB1*04:02 (core) → C-NPMM → nonpermissive
