# Hacker News API Reference

## Firebase API (no auth, no rate limit)

Base: `https://hacker-news.firebaseio.com/v0/`

### Items
`GET /item/{id}.json`
Fields: id, deleted, type (job|story|comment|poll|pollopt), by, time (unix), text (HTML), dead, parent, poll, kids[], url, score, title, parts, descendants

### Users
`GET /user/{id}.json`
Fields: id, created (unix), karma, about (HTML), submitted[]

### Story Lists (return arrays of item IDs)
| Endpoint | Content | Max |
|---|---|---|
| `/topstories.json` | Top stories + jobs | 500 |
| `/newstories.json` | Newest stories | 500 |
| `/beststories.json` | Best stories | 500 |
| `/askstories.json` | Ask HN | 200 |
| `/showstories.json` | Show HN | 200 |
| `/jobstories.json` | Jobs | 200 |

### Other
- `/maxitem.json` — current largest item ID
- `/updates.json` — `{items: [...], profiles: [...]}` recently changed

## Algolia Search API (no auth)

Base: `https://hn.algolia.com/api/v1/`

### Search
- `GET /search?query=Q&tags=TAG&hitsPerPage=N&page=P&numericFilters=FILTER` — relevance sort
- `GET /search_by_date?...` — chronological sort

**Tags:** story, comment, poll, show_hn, ask_hn, front_page, author_USERNAME, story_ID

**Numeric filters:** `created_at_i>TIMESTAMP`, `points>N`, `num_comments>N`

**Response hits:** objectID, title, url, author, points, num_comments, created_at, story_text, comment_text
