---
name: Hacker News
slug: hacker-news
version: 1.0.0
description: Search and browse Hacker News with API access to stories, comments, users, and hiring threads.
metadata: {"clawdbot":{"emoji":"🟠","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| Topic | File |
|-------|------|
| API endpoints | `api.md` |
| Search patterns | `search.md` |

## Core Rules

### 1. Two APIs Available
| API | Use Case | Base URL |
|-----|----------|----------|
| Official HN API | Single items, real-time | `https://hacker-news.firebaseio.com/v0` |
| Algolia Search | Full-text search, filters | `https://hn.algolia.com/api/v1` |

### 2. Official API Endpoints
- `/topstories.json` — top 500 story IDs
- `/newstories.json` — newest 500 story IDs  
- `/beststories.json` — best stories
- `/askstories.json` — Ask HN
- `/showstories.json` — Show HN
- `/jobstories.json` — job postings
- `/item/{id}.json` — story/comment details
- `/user/{username}.json` — user profile

### 3. Algolia Search Syntax
```
/search?query=TERM&tags=TAG&numericFilters=FILTER
```

**Tags (combinable with AND):**
- `story`, `comment`, `poll`, `job`, `ask_hn`, `show_hn`
- `author_USERNAME` — posts by user
- `story_ID` — comments on story

**Numeric filters:**
- `created_at_i>TIMESTAMP` — after date
- `points>N` — minimum points
- `num_comments>N` — minimum comments

### 4. Common Patterns
| Request | Endpoint |
|---------|----------|
| Frontpage | Official `/topstories.json` → fetch first 30 items |
| Search posts | Algolia `/search?query=X&tags=story` |
| User's posts | Algolia `/search?tags=author_USERNAME` |
| Who is hiring? | Algolia `/search?query=who is hiring&tags=story,author_whoishiring` |
| Comments on story | Algolia `/search?tags=comment,story_ID` |
| This week's top | Algolia `/search?tags=story&numericFilters=created_at_i>WEEK_TS` |

### 5. Response Handling
- Official API returns IDs → batch fetch items (parallelize)
- Algolia returns full objects with `hits[]` array
- Story object: `id`, `title`, `url`, `score`, `by`, `time`, `descendants` (comment count)
- Comment object: `id`, `text`, `by`, `parent`, `time`

### 6. Rate Limits
- Official API: No auth required, generous limits
- Algolia: 10,000 requests/hour (no key needed)
- Always paginate large results (`page=N`, `hitsPerPage=N`)

### 7. Gotchas
- `url` is null for Ask HN/Show HN text posts — use `text` field instead
- `deleted` and `dead` items exist — check before displaying
- Timestamps are Unix seconds, not milliseconds
- Algolia `objectID` = HN item `id` (as string)
