---
name: hackathon-manager
description: Track hackathon deadlines, manage submission checklists, and monitor progress. Use when managing multiple hackathons, checking what's due soon, marking requirements complete, or extracting hackathon information from URLs to auto-populate deadlines and requirements.
---

# Hackathon Manager

Track multiple hackathons with deadlines, prizes, and submission checklists. Automatically extract hackathon details from URLs and manage progress toward submission.

## Quick Start

Run commands using the manager.py script:

```bash
python scripts/manager.py <command> [args]
```

## Core Commands

### Add a Hackathon

```bash
python scripts/manager.py add "Hackathon Name" "YYYY-MM-DD" "Prize Amount"
```

Example:
```bash
python scripts/manager.py add "Solana Agent Hackathon" "2026-02-12" "$50K"
```

**From URL:** When given a hackathon URL, use web_fetch to extract:
- Hackathon name
- Deadline date
- Prize pool
- Submission requirements

Then call add command with extracted info and populate checklist.

### List All Hackathons

```bash
python scripts/manager.py list
```

Shows table with name, deadline, status, and progress for all tracked hackathons.

### View Status

```bash
python scripts/manager.py status "Hackathon Name"
```

Shows detailed view including full checklist with completion status.

### Check Off Item

```bash
python scripts/manager.py check "Hackathon Name" "Item text or number"
```

Mark a checklist item as complete. Accepts either:
- Full item text: `check "Solana Agent" "Deploy to devnet"`
- Item number: `check "Solana Agent" "2"`

### View Upcoming

```bash
python scripts/manager.py upcoming [days]
```

Show hackathons due in next N days (default 7). Sorted by urgency with visual indicators.

### Text Calendar View

```bash
python scripts/manager.py calendar [month] [year]
```

Display a text calendar with hackathon markers:
- `R` = Registration opens
- `W` = Work period starts
- `D` = Submission deadline

## Google Calendar Integration

Sync hackathons to Google Calendar using the gog CLI. Requires [gog](https://github.com/rubiojr/gog) to be installed and authenticated.

### List Calendar Events

```bash
python scripts/manager.py gcal list
```

Show all hackathon-related events currently in Google Calendar.

### Sync to Calendar

```bash
python scripts/manager.py gcal sync
```

Create Google Calendar events for all tracked hackathons:
- `[REG]` - Registration opens (timed event)
- `[WORK]` - Work period (all-day event)
- `[DEADLINE]` - Submission deadline (timed event)

### Remove from Calendar

```bash
python scripts/manager.py gcal remove "Hackathon Name"
```

Delete all calendar events matching the hackathon name.

**Note for Windows:** The skill auto-configures the Go timezone database. If you get timezone errors, ensure `~/.gog/zoneinfo.zip` exists.

## Workflow

**When user mentions hackathons:**

1. **Adding from URL:** If they provide a hackathon link:
   - Use web_fetch to get the page
   - Extract name, deadline, prize, requirements
   - Run add command
   - Populate checklist with requirements

2. **Manual add:** If they provide details:
   - Run add command with provided info
   - Ask what checklist items to track

3. **Checking status:** If they ask "what's due?" or "what hackathons?":
   - Run list or upcoming command
   - Show relevant information

4. **Managing progress:** If they mention completing something:
   - Identify the hackathon and item
   - Run check command
   - Confirm completion

## Data Storage

Hackathons stored in JSON at: `~/.openclaw/workspace/hackathons.json`

Structure:
```json
{
  "hackathons": [
    {
      "name": "Hackathon Name",
      "deadline": "YYYY-MM-DD",
      "prize": "$50K",
      "status": "active",
      "checklist": ["Item 1", "Item 2"],
      "completed": ["Item 1"]
    }
  ]
}
```

## Integration with HACKATHONS.md

When HACKATHONS.md exists in workspace:
- Read it to discover hackathons not yet in the JSON store
- Suggest importing them
- Keep both files in sync when adding new hackathons

## Notes

- Data stored in `~/.openclaw/workspace/hackathons.json`
- Google Calendar integration requires [gog CLI](https://github.com/rubiojr/gog)
- Events are prefixed with `[REG]`, `[WORK]`, or `[DEADLINE]` for easy identification
- The `gcal remove` command matches hackathon name in event titles
