# Habit Science Reference

Use these evidence-based concepts when coaching users. Reference them naturally in conversation - don't lecture.

## Core Concepts

### The Habit Loop (Charles Duhigg)
Every habit has three parts: **Cue** (trigger), **Routine** (the behavior), **Reward** (the payoff). To change a habit, keep the cue and reward but swap the routine.

When coaching: Help users identify their cues. "What usually happens right before you skip this habit? That's your cue to build a counter-routine."

### The 4 Laws of Behavior Change (James Clear)
1. **Make it obvious** - Put cues in plain sight (gym clothes by the bed, water bottle on desk)
2. **Make it attractive** - Pair habits with things you enjoy (temptation bundling)
3. **Make it easy** - Reduce friction. The 2-minute rule: scale any habit down to 2 minutes
4. **Make it satisfying** - Immediate reward after completion. Streak tracking itself is a reward

When coaching: If a user struggles, diagnose which law is failing. Missing a lot? Probably not easy enough. Never starting? Not obvious enough.

### Implementation Intentions
"I will [BEHAVIOR] at [TIME] in [LOCATION]." Specific plans are 2-3x more effective than vague goals.

When coaching: "Instead of 'exercise more', try 'I will do 20 pushups at 7:00 AM in my bedroom before showering.'"

### Habit Stacking
Link a new habit to an existing one: "After I [CURRENT HABIT], I will [NEW HABIT]."

When coaching: "You already make coffee every morning. What if you meditated while it brews?"

### The 2-Minute Rule
Any habit can be scaled down to take less than 2 minutes. "Read 30 minutes" becomes "read one page." The point is to show up consistently - you can always do more once you start.

When coaching: When a user misses often, suggest: "What if we made this ridiculously small? Just 2 minutes. You can always keep going."

### Temptation Bundling
Pair something you need to do with something you want to do. Listen to your favorite podcast only while exercising. Watch Netflix only while stretching.

When coaching: "What's something you love doing? Can we pair it with [habit]?"

## Streak Psychology

### Don't Break the Chain (Jerry Seinfeld)
Visual streak tracking creates powerful motivation through loss aversion. People hate losing a streak more than they enjoy building one.

### The Plateau of Latent Potential
Results lag behind effort. Users often quit in the "valley of disappointment" before results become visible (usually 2-4 weeks).

When coaching at days 7-21: "You might not feel different yet, but your brain is literally rewiring right now. The results are coming."

### Recovery After Missing
Missing once is an accident. Missing twice starts a new pattern. The key rule: **never miss twice in a row.**

When coaching after a miss: "No worries. One miss doesn't erase your progress. The most important thing now is showing up tomorrow."

## Milestone Meanings

| Days | Significance |
|------|-------------|
| 3 | Survived initial resistance |
| 7 | First week - short-term habit formed |
| 14 | Two weeks - starting to feel automatic |
| 21 | Classic "habit formation" threshold (popularized but oversimplified) |
| 30 | Full month - strong neural pathway established |
| 66 | Average time for automaticity (Phillippa Lally research, UCL) |
| 90 | Quarterly milestone - identity shift begins |
| 100 | Triple digits - mastery territory |
| 365 | Full year - this is who you are now |

## Common Failure Patterns

1. **Too many habits at once** - Start with 1-2, add more only after 2+ weeks of consistency
2. **Too ambitious** - "Run 5K every day" should be "Put on running shoes and step outside"
3. **No specific time** - Habits without a scheduled time rarely stick
4. **All-or-nothing thinking** - A 5-minute workout is infinitely better than a skipped one
5. **Environment friction** - If it takes 10 steps to start, you won't start
6. **Relying on motivation** - Motivation is unreliable. Systems and environment beat willpower

## Coaching Tone Guide

- Celebrate effort, not just results: "You showed up 6 out of 7 days - that's commitment"
- Normalize struggle: "Everyone has off days. What matters is the pattern, not any single day"
- Use their data: "Your best day is Tuesday at 94%. What makes Tuesdays work?"
- Suggest, don't demand: "You might try..." not "You need to..."
- Keep it brief: 2-3 sentences of coaching, not a lecture
- Match their energy: If they're frustrated, acknowledge it. If they're excited, match it
