# Workouts & Routines

## Program Selection by Experience

| Level | Days/Week | Recommended |
|-------|-----------|-------------|
| Beginner (0-1yr) | 3 | Full Body A/B/A |
| Intermediate (1-3yr) | 4 | Upper/Lower or Push/Pull/Legs |
| Advanced (3yr+) | 5-6 | PPL, Arnold Split, or Specialized |

## Full Body Template (Beginner)

### Day A
1. Squat variation — 3x8-12
2. Horizontal push (bench) — 3x8-12
3. Horizontal pull (row) — 3x8-12
4. Accessory (arms/core) — 2x12-15

### Day B
1. Hip hinge (deadlift/RDL) — 3x6-10
2. Vertical push (OHP) — 3x8-12
3. Vertical pull (pulldown/pull-up) — 3x8-12
4. Accessory (shoulders/core) — 2x12-15

## Upper/Lower Template (Intermediate)

### Upper A (Push Focus)
1. Bench press — 4x6-8
2. Incline DB press — 3x10-12
3. Barbell row — 4x8-10
4. Lateral raises — 3x12-15
5. Tricep work — 3x12-15

### Lower A (Quad Focus)
1. Squat — 4x6-8
2. Leg press — 3x10-12
3. RDL — 3x10-12
4. Leg curl — 3x12-15
5. Calf raises — 4x12-15

## Push/Pull/Legs Template (Advanced)

### Push
1. Bench press — 4x5-8
2. OHP — 3x8-10
3. Incline DB — 3x10-12
4. Cable flies — 3x12-15
5. Lateral raises — 4x12-15
6. Tricep pushdown — 3x12-15

### Pull
1. Weighted pull-ups — 4x6-8
2. Barbell row — 4x8-10
3. Face pulls — 3x15-20
4. Lat pulldown — 3x10-12
5. Rear delt flies — 3x15-20
6. Bicep curls — 3x12-15

### Legs
1. Squat — 4x5-8
2. RDL — 4x8-10
3. Leg press — 3x12-15
4. Leg curl — 3x12-15
5. Walking lunges — 3x10/leg
6. Calf raises — 4x12-15

## Exercise Substitutions

When equipment unavailable or exercise contraindicated:

| If You Can't Do | Try Instead |
|-----------------|-------------|
| Barbell squat | Goblet squat, leg press, hack squat |
| Conventional deadlift | Trap bar deadlift, RDL, hip thrust |
| Bench press | DB press, push-ups, machine chest press |
| Pull-ups | Lat pulldown, assisted pull-ups, rows |
| Barbell row | Cable row, DB row, chest-supported row |
| Overhead press | Landmine press, DB shoulder press, Arnold press |

## Rep Ranges by Goal

| Goal | Reps | Sets | Rest |
|------|------|------|------|
| Strength | 1-5 | 4-6 | 3-5min |
| Hypertrophy | 6-12 | 3-4 | 90-120s |
| Endurance | 12-20 | 2-3 | 30-60s |
| Power | 1-5 explosive | 3-5 | 2-3min |

## Time-Efficient Formats

### 30-Minute Full Body
Superset format, minimal rest:
- A1: Squat 3x10 / A2: Push-up 3x15
- B1: RDL 3x10 / B2: Row 3x10
- C1: Plank 2x30s / C2: Curls 2x12

### 45-Minute Upper/Lower
- 4 exercises, 3 sets each
- 90s rest between sets
- Compounds only, no isolation

### Hotel/Bodyweight
- Push-ups (regular, diamond, wide) — 3x max
- Bulgarian split squats — 3x12/leg
- Inverted rows (under desk/table) — 3x max
- Plank variations — 3x45s
- Glute bridges — 3x20
