# Progress Tracking & Progression

## Workout Log Format

Store in `~/gym/workouts.md`:
```
## 2024-01-15 - Push Day
- Bench Press: 80kg 4x8,8,7,6 RPE 8
- OHP: 50kg 3x10,10,9
- Incline DB: 30kg 3x12
- Lateral Raises: 12kg 3x15
Notes: Left shoulder tight on last set of OHP
```

## PR Tracking

Store in `~/gym/prs.md`:
```
## Bench Press
- 1RM: 100kg (2024-01-01)
- 5RM: 85kg (2024-01-10)
- 10RM: 70kg (2024-01-05)

## Squat
- 1RM: 140kg (2024-01-08)
```

## Progression Methods

### Linear Progression (Beginners)
- Add weight every session: +2.5kg upper, +5kg lower
- When you fail to complete all reps, stay at same weight
- After 2-3 sessions at same weight, deload 10%

### Double Progression (Intermediate)
- Set a rep range (e.g., 3x8-12)
- Start at bottom of range with current weight
- Add reps each session until top of range
- When hitting top of range for all sets, increase weight and restart

### RPE-Based (Advanced)
| RPE | Meaning | Action |
|-----|---------|--------|
| 6-7 | 3-4 reps in reserve | Warm-up weight, increase |
| 8 | 2 reps in reserve | Target for main sets |
| 9 | 1 rep in reserve | Acceptable for top sets |
| 10 | Max effort | Only for testing, not training |

## Volume Landmarks

### Sets Per Muscle Group Per Week
| Level | Minimum | Target | Maximum |
|-------|---------|--------|---------|
| Beginner | 6 | 10-12 | 15 |
| Intermediate | 10 | 15-18 | 22 |
| Advanced | 12 | 18-22 | 25+ |

### Detecting Over/Under Training
- Under: <MV sets, strength declining, always feeling fresh
- Optimal: Steady progress, moderate soreness, good recovery
- Over: Strength plateau, chronic fatigue, joint pain, poor sleep

## Deload Protocol

### When to Deload
- Every 4-6 weeks of hard training
- Persistent fatigue despite good sleep
- Joints aching (not just muscle soreness)
- Motivation crashes
- Strength decline across multiple exercises

### How to Deload
- **Volume deload:** Keep weight, reduce sets by 40-50%
- **Intensity deload:** Keep sets, reduce weight by 40-50%
- **Full deload:** 50% volume AND 50% intensity
- Duration: 1 week (3-4 sessions)

## Stall Troubleshooting

### If Progress Stops
1. **Check sleep** — <7h consistently kills gains
2. **Check calories** — eating enough to support training?
3. **Check recovery** — too much life stress?
4. **Check volume** — too much or too little?
5. **Change stimulus** — same exercise for months? Rotate

### Breaking Plateaus
- Change rep scheme (5x5 → 3x8)
- Change exercise variation (back squat → front squat)
- Add pause reps or tempo work
- Reduce frequency, increase intensity
- Strategic deload followed by peaking phase

## Body Measurements

Store in `~/gym/measurements.md`:
```
## 2024-01-01
- Weight: 82.5kg (morning, fasted)
- Chest: 102cm
- Waist: 84cm
- Hips: 98cm
- Arms: 38cm
- Thighs: 60cm

## Notes
- Measure same time, same conditions
- Weekly weight, monthly circumferences
- Use 7-day weight average for trends
```

## Progress Indicators

### Good Signs
- Strength increasing (even slowly)
- Body composition improving (clothes fit better)
- Energy levels good
- Sleep quality maintained
- Enjoying training

### Warning Signs
- Same weight/reps for 3+ weeks
- Dreading the gym
- Chronic joint pain (not just muscle soreness)
- Sleep getting worse
- Appetite suppressed
