# Gym Nutrition Basics

## Calorie Targets by Goal

### Maintenance
- TDEE = BMR × Activity Multiplier
- Sedentary (desk job): BMR × 1.2
- Light activity (3x gym): BMR × 1.375
- Moderate (4-5x gym): BMR × 1.55
- Very active (6-7x + physical job): BMR × 1.725

### Muscle Gain (Bulk)
- Surplus: TDEE + 200-300 kcal (lean bulk)
- Aggressive: TDEE + 500 kcal (more fat gain)
- Protein: 1.6-2.2g per kg bodyweight
- Rate: 0.25-0.5kg per week

### Fat Loss (Cut)
- Deficit: TDEE - 300-500 kcal (sustainable)
- Aggressive: TDEE - 750-1000 kcal (short term only)
- Protein: 2.0-2.4g per kg (preserve muscle)
- Rate: 0.5-1% bodyweight per week

### Body Recomposition
- Eat at maintenance or slight deficit
- High protein (2g/kg)
- Works best for beginners and overweight lifters
- Slower but sustainable

## Protein Timing

### Daily Distribution
- Spread across 4-5 meals (20-40g per meal)
- No need for protein immediately post-workout
- But within 2-3 hours of training is ideal
- Pre-sleep protein (casein or cottage cheese) may help recovery

### Protein Sources (per 100g)
| Source | Protein | Notes |
|--------|---------|-------|
| Chicken breast | 31g | Lean, versatile |
| Greek yogurt | 10g | Also has casein |
| Eggs | 13g | Complete profile |
| Salmon | 25g | Omega-3 bonus |
| Tofu | 8g | Plant-based |
| Lentils | 9g | Fiber bonus |
| Whey powder | 75-80g | Convenient |

## Pre-Workout Nutrition

### 2-3 Hours Before
- Full meal: carbs + protein + some fat
- Example: Rice + chicken + vegetables

### 1 Hour Before
- Light snack: mostly carbs, some protein
- Example: Banana + protein shake

### <30 Minutes Before
- Simple carbs if anything: fruit, juice
- Avoid fat (slows digestion)

### Fasted Training
- Fine for cardio/light sessions
- For heavy strength: eat something
- If fasted, prioritize post-workout meal

## Post-Workout Nutrition

### The "Anabolic Window" Myth
- Total daily protein matters more than timing
- But eating within 2-3 hours is practical and beneficial
- No need for immediate shake unless next meal is 4+ hours away

### Good Post-Workout Options
- Protein + carbs combo
- Shake + banana
- Chicken + rice
- Greek yogurt + granola

## Hydration

### Daily Target
- Baseline: 30-35ml per kg bodyweight
- Add 500ml per hour of training
- More in hot conditions

### Signs of Dehydration
- Dark urine
- Headache during training
- Strength drops
- Cramps

### Electrolytes
- Needed for sessions >90min
- Or heavy sweaters
- Salt in food usually sufficient
- Sports drinks or electrolyte tabs if needed

## Supplements Worth Considering

### Evidence-Based
| Supplement | Dose | Why |
|------------|------|-----|
| Creatine monohydrate | 5g/day | Proven for strength, cheap |
| Protein powder | As needed | Convenience, not magic |
| Caffeine | 3-6mg/kg | Pre-workout performance |
| Vitamin D | 1000-2000 IU | If deficient (most people) |

### Skip These
- BCAAs (waste if eating enough protein)
- Fat burners (mostly caffeine at 10x the price)
- Testosterone boosters (don't work)
- Pre-workouts with proprietary blends (unknown doses)

## Common Mistakes

- **Eating too little on bulk** — If not gaining, eat more
- **Eating too little protein on cut** — Muscle loss
- **Ignoring fiber** — Digestion problems, hunger
- **Obsessing over meal timing** — Total intake matters more
- **Drinking calories** — Easy to overconsume
- **"Earning" food with exercise** — Leads to poor relationship with food
