# Injury Adaptation & Modifications

## Common Restriction Profiles

### Lower Back Issues
**Avoid:**
- Conventional deadlifts with heavy load
- Good mornings
- Bent-over rows with poor form
- Sit-ups/crunches (flexion under load)

**Substitute:**
- Deadlift → Trap bar deadlift, hip thrust, cable pull-through
- Rows → Chest-supported row, cable row seated
- Core → Dead bugs, bird dogs, pallof press, planks

**Prehab:** McGill Big 3 (curl-up, side plank, bird dog) before every session

### Knee Issues
**Avoid:**
- Deep squats if painful in the hole
- Leg extensions with high load
- Box jumps and plyometrics
- Lunges with knee passing toe excessively

**Substitute:**
- Deep squat → Box squat to safe depth, leg press with limited ROM
- Leg extension → Terminal knee extensions (TKE), step-ups
- Lunges → Reverse lunges, split squat with rear foot elevated

**Prehab:** Banded terminal knee extensions, wall sits, single-leg balance

### Shoulder Issues (Rotator Cuff)
**Avoid:**
- Behind-neck press
- Upright rows (internal rotation under load)
- Deep dips
- Flies with excessive ROM at bottom
- Bench press with elbows >75° from torso

**Substitute:**
- OHP → Landmine press, Z-press, Arnold press
- Bench → Floor press, neutral grip DB press
- Dips → Close-grip bench, cable pushdown
- Flies → Cable crossover with controlled ROM

**Prehab:** Band pull-aparts, face pulls, external rotation work

### Wrist Issues
**Avoid:**
- Barbell front squats (wrist extension)
- Straight bar curls if painful
- Heavy pressing that requires wrist extension

**Substitute:**
- Front squat → Cross-arm grip, safety squat bar, goblet
- Barbell curl → EZ bar curl, hammer curls
- Pressing → Neutral grip DB press, push-ups on parallettes

## Age-Related Adaptations

### 40+ Considerations
- Longer warm-ups (10-15min vs 5min)
- More recovery time between sessions (72h vs 48h)
- Emphasize joint-friendly variations
- RPE-based progression over linear weight increases
- Include mobility work every session

### 50+ Considerations
- Prioritize movement quality over load
- Machine-based work safer than free weights for isolation
- Higher rep ranges (8-15 vs 5-8)
- Address balance and stability
- Regular deloads (every 3-4 weeks)

## Working Around Equipment Limits

### Home Gym with Dumbbells Only
- Compound lifts: Goblet squat, DB RDL, DB row, DB press
- Single leg work compensates for limited load
- Tempo training increases difficulty without weight
- Supersets and circuits for conditioning

### Planet Fitness (No Barbell)
- Smith machine for squat/press patterns (not ideal but works)
- DB and cable work for everything else
- Machines for progressive overload tracking
- Focus on mind-muscle connection

### Hotel/Travel
- Bodyweight progressions (see workouts.md)
- Resistance bands for rows and presses
- Furniture for dips, rows, step-ups
- Maintain strength, don't try to gain

## Progression After Injury

### Phase 1: Acute (0-2 weeks)
- Rest affected area completely
- Work non-affected areas
- Focus on nutrition and sleep

### Phase 2: Rehabilitation (2-6 weeks)
- Follow physio protocol exactly
- Low load, high rep therapeutic exercises
- Gradually increase ROM

### Phase 3: Return to Training (6-12 weeks)
- Start at 50% of pre-injury load
- Progress 5-10% per week maximum
- Stop immediately if pain returns
- Keep 2-3 reps in reserve always

### Phase 4: Full Training
- May need permanent modifications
- Periodically check that pain hasn't returned
- Maintain prehab routine indefinitely
