# FTdesign HTML 生成器技能

## 技能概述

本技能能够根据用户的自然语言描述，自动生成符合FTdesign设计规范的HTML预览界面。支持列表页、表单页、详情页三种主要页面类型，生成的页面可直接在浏览器中预览。

## 触发条件

当用户需求满足以下任一条件时，自动加载本技能：

1. 用户明确要求"生成HTML页面"或"生成预览界面"
2. 用户描述中包含页面类型关键词：
   - 列表页/表格页/查询页面（关键词：列表、表格、查询、管理、浏览）
   - 表单页/编辑页/新建页（关键词：表单、编辑、新建、添加、创建）
   - 详情页/查看页（关键词：详情、查看、详情页、查看页面）
3. 用户提及FTdesign相关设计规范

## 技能工作流程

### 第一步：页面类型识别

通过关键词匹配确定页面类型：

- **列表页**：包含"列表、表格、查询、管理"等关键词
- **表单页**：包含"表单、编辑、新建、添加、创建"等关键词  
- **详情页**：包含"详情、查看、详情页、查看页面"等关键词

### 第二步：模板选择

根据页面类型选择对应的模板文件：

- 列表页 → `assets/templates/list-page.html`
- 表单页 → `assets/templates/form-page.html`
- 详情页 → `assets/templates/detail-page.html`

### 第三步：数据填充

解析用户需求，提取以下信息：

1. **页面标题**：如"用户管理"、"文章列表"
2. **字段信息**：字段名称、字段类型、是否必填
3. **操作按钮**：查询、新建、编辑、删除、保存、取消等
4. **数据示例**：用于生成示例数据

### 第四步：生成HTML

生成完整的HTML文件，包含：
1. 基础布局（侧边栏 + 主内容区）
2. 页头（面包屑 + 标题）
3. 内容区域（根据页面类型生成）
4. 样式定义（完整的CSS变量系统）
5. 图标资源（Remix Icon CDN）

### 第五步：输出结果

生成HTML文件并在IDE预览窗口中打开。

## 设计系统规范

### 布局规范

#### 固定侧边栏模式
- 侧边栏：`position: fixed`，宽度240px
- 主内容区：`margin-left: 240px`
- 禁止在React组件根元素或#root使用display:flex布局

#### 页面结构
- 页头模块：面包屑 + 标题，白色背景
- 内容区域：白色卡片，24px外边距，2px圆角
- 筛选区和操作区：`flex-direction: column`，`gap: 16px`

### 组件规范

#### 按钮组件（统一高度32px）
- 主按钮（`ft-btn-primary`）：品牌色背景
- 次按钮（`ft-btn-default`）：白色背景
- 虚线按钮（`ft-btn-dashed`）：虚线边框
- 链接按钮（`ft-btn-link`）：无背景

#### 表单组件
- 输入框（`ft-input`）：高度32px，focus时品牌色边框
- 选择框（`ft-select`）：高度32px，箭头位置right:12px
- 文本域（`ft-textarea`）：最小高度120px
- 单选/复选框：16px尺寸

#### 表格组件
- 表头背景：`var(--ft-grey-1)`
- 行悬停：`var(--ft-grey-1)`背景色
- 单元格padding：12px 16px

#### 标签组件
- 高度：22px
- 状态：成功（绿色）、警告（橙色）、错误（红色）

### 侧边栏规范

#### 浅色风格（必须遵守）
- 背景色：`#FFFFFF` (`var(--ft-grey-0)`)
- 右边框：`#E6E8EC` (`var(--ft-grey-3)`)
- 文字颜色：`#39485E` (`var(--ft-grey-7)`)
- 激活状态背景：`#EFF0FA` (`var(--ft-brand-color-bg)`)
- 激活状态高亮：左侧2px `#005DEB` 火柴棍

#### 图标完整性
- 所有菜单项必须包含图标
- 常用图标映射：
  - 仪表盘：`ri-dashboard-line`
  - 用户管理：`ri-user-line`
  - 角色管理：`ri-team-line`
  - 权限管理：`ri-shield-check-line`
  - 系统设置：`ri-settings-3-line`
  - 列表管理：`ri-file-list-3-line`

### CSS变量系统

```css
:root {
    /* 品牌色 */
    --ft-brand-color: #005DEB;
    --ft-brand-color-hover: #267DFF;
    --ft-brand-color-active: #004BBF;
    --ft-brand-color-bg: #EFF0FA;

    /* 中性色（10级灰阶） */
    --ft-grey-0: #FFFFFF;
    --ft-grey-1: #F7F8FA;
    --ft-grey-2: #F2F3F5;
    --ft-grey-3: #E6E8EC;
    --ft-grey-4: #D1D5DB;
    --ft-grey-5: #9CA3AF;
    --ft-grey-6: #6B7280;
    --ft-grey-7: #39485E;
    --ft-grey-8: #1F2937;
    --ft-grey-9: #111827;

    /* 功能色 */
    --ft-success-color: #10B981;
    --ft-warning-color: #F59E0B;
    --ft-error-color: #EF4444;

    /* 阴影与圆角 */
    --ft-shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    --ft-shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --ft-radius-sm: 2px;
    --ft-radius-md: 4px;

    /* 布局尺寸 */
    --ft-sidebar-width: 240px;
    --ft-header-height: 64px;
}
```

## 技能文件结构

```
.codebuddy/skills/ftdesign-html-generator/
├── SKILL.md                    # 本文件 - 技能核心指令
├── README.md                   # 使用指南
├── references/
│   ├── design-system.md       # FTdesign设计系统完整规范
│   ├── components-api.md      # 组件使用指南和API
│   └── examples.md           # 代码示例库
├── assets/
│   ├── templates/
│   │   ├── base-layout.html   # 基础布局模板
│   │   ├── list-page.html     # 列表页模板
│   │   ├── form-page.html     # 表单页模板
│   │   └── detail-page.html   # 详情页模板
│   └── css/
│       └── ftdesign-vars.css  # CSS变量定义文件
└── scripts/
    └── generate-html.py       # HTML生成脚本（Python，可选）
```

## 生成规则

### 列表页生成规则

1. **必须包含**：
   - 查询筛选区（至少一个查询条件）
   - 查询/重置按钮
   - 数据表格
   - 分页组件
   - 新建按钮

2. **表格列结构**：
   - ID列（宽度60px）
   - 业务字段列
   - 操作列（宽度180px）

3. **操作按钮**：查看、编辑、删除

### 表单页生成规则

1. **必须包含**：
   - 表单字段（至少3个）
   - 表单操作按钮（保存、取消）
   - 必填字段标识

2. **表单布局**：
   - 单列布局：宽表单
   - 双列布局：两字段并排

3. **字段类型支持**：
   - 文本输入
   - 下拉选择
   - 文本域
   - 单选框
   - 复选框
   - 日期选择

### 详情页生成规则

1. **必须包含**：
   - 标题和元数据区
   - 信息网格展示
   - 操作按钮（编辑、返回）

2. **信息结构**：
   - 标题：28px，600字重
   - 元数据：作者、时间、浏览量、状态
   - 信息网格：标签+值的两列布局

## 生成示例

### 示例1：用户管理列表页

**用户输入**：
```
生成一个用户管理列表页，包含用户名、邮箱、角色、状态字段，支持查询和新建操作
```

**技能输出**：
- 识别为列表页
- 应用列表页模板
- 生成查询表单（用户名输入框、状态下拉框）
- 生成数据表格（ID、用户名、邮箱、角色、状态、操作列）
- 生成分页组件
- 侧边栏激活"用户管理"菜单项

### 示例2：文章编辑表单

**用户输入**：
```
生成文章编辑表单，包含标题（必填）、分类（必填）、作者、摘要、内容字段
```

**技能输出**：
- 识别为表单页
- 应用表单页模板
- 生成表单字段（标题、分类、作者、摘要、富文本编辑器）
- 标记必填字段
- 生成操作按钮（保存、预览、取消）

### 示例3：订单详情页

**用户输入**：
```
生成订单详情页，展示订单号、商品信息、金额、状态等信息
```

**技能输出**：
- 识别为详情页
- 应用详情页模板
- 生成标题和元数据区
- 生成信息网格（订单号、金额、状态等）
- 生成商品列表区
- 生成操作按钮（编辑、返回列表）

## 注意事项

1. **样式一致性**：所有组件必须使用统一的CSS变量系统
2. **响应式设计**：生成的页面应支持基本的响应式适配
3. **交互状态**：按钮、输入框等组件必须包含hover、focus、active状态
4. **图标完整性**：侧边栏菜单项必须包含图标，不能缺失
5. **禁止使用**：绝对禁止使用Emoji表情符号，统一使用Remix Icon

## 扩展功能

### 自定义模板

用户可以修改 `assets/templates/` 目录下的模板文件，定制自己的页面样式。

### 自定义样式

通过修改 `assets/css/ftdesign-vars.css` 可以自定义CSS变量，覆盖设计规范。

### Python脚本辅助

`scripts/generate-html.py` 提供命令行方式生成HTML，方便批量处理。

## 故障排查

### 问题1：生成页面样式不正确

**解决方案**：检查CSS变量是否正确引入，确保使用了完整的变量系统。

### 问题2：侧边栏图标缺失

**解决方案**：确保侧边栏菜单项都包含了图标，使用标准的Remix Icon类名。

### 问题3：表格列宽不统一

**解决方案**：参考模板中的列宽设置，ID列60px，操作列180px。

## 版本信息

- 版本：1.0.0
- 最后更新：2024-02-26
- 适用FTdesign版本：完整版
