# FTdesign HTML 生成器 - 使用指南

## 快速开始

### 触发技能

在对话中使用以下任一方式触发技能：

1. **直接描述需求**：
   ```
   生成一个用户管理列表页，包含姓名、邮箱、角色字段
   ```

2. **明确请求**：
   ```
   使用FTdesign规范生成文章编辑表单
   ```

3. **关键词触发**：
   ```
   帮我做个订单查询页面
   ```

### 支持的页面类型

| 页面类型 | 触发关键词 | 说明 |
|---------|-----------|------|
| 列表页 | 列表、表格、查询、管理、浏览 | 展示数据列表，支持查询和操作 |
| 表单页 | 表单、编辑、新建、添加、创建 | 数据录入和编辑 |
| 详情页 | 详情、查看、详情页、查看页面 | 数据详情展示 |

## 常见用法

### 用法1：生成简单的列表页

```
生成一个商品列表页，包含商品名称、价格、库存、状态字段
```

### 用法2：生成带查询的列表页

```
生成用户管理列表，可以按用户名和状态查询，显示用户名、邮箱、角色、注册时间
```

### 用法3：生成新建表单

```
生成商品新建表单，包含商品名称（必填）、分类（必填）、价格、库存、描述字段
```

### 用法4：生成编辑表单

```
生成文章编辑表单，包含标题、分类、作者、摘要、正文内容字段，使用富文本编辑器
```

### 用法5：生成详情页

```
生成订单详情页，展示订单号、商品信息、金额、支付状态、配送信息
```

### 用法6：复杂页面组合

```
生成一个完整的文章管理模块，包括：
1. 文章列表页（查询、新建、编辑、删除）
2. 文章编辑页（标题、分类、作者、摘要、内容）
3. 文章详情页（基本信息、正文内容、操作历史）
```

## 字段说明

### 常用字段类型

| 字段类型 | 生成组件 | 示例 |
|---------|---------|------|
| 文本 | `<input type="text">` | 用户名、标题 |
| 数字 | `<input type="number">` | 价格、库存 |
| 邮箱 | `<input type="email">` | 邮箱地址 |
| 日期 | `<input type="date">` | 出生日期 |
| 选择 | `<select>` | 分类、角色 |
| 文本域 | `<textarea>` | 描述、摘要 |
| 富文本 | 自定义编辑器 | 正文内容 |

### 必填字段标识

在字段名后添加"(必填)"即可标记为必填：

```
生成表单，包含用户名（必填）、邮箱（必填）、手机号
```

### 自定义列宽

列表页的表格列宽设置：
- ID列：60px
- 状态列：100px
- 操作列：180px
- 其他列：自适应或指定宽度

## 侧边栏菜单

### 默认菜单项

技能会自动根据页面类型设置侧边栏菜单：

| 页面类型 | 默认菜单 | 图标 |
|---------|---------|------|
| 通用列表 | 相应模块 | `ri-file-list-3-line` |
| 用户管理 | 用户管理 | `ri-user-line` |
| 角色管理 | 角色管理 | `ri-team-line` |
| 权限管理 | 权限管理 | `ri-shield-check-line` |
| 系统设置 | 系统设置 | `ri-settings-3-line` |

### 自定义菜单

可以在需求中指定菜单项和图标：

```
生成一个订单管理列表页，侧边栏菜单项使用"订单管理"，图标用ri-shopping-cart-line
```

## 输出结果

### 生成的文件

技能会在工作区生成HTML文件，文件名规则：
- 列表页：`{模块名}-list.html`
- 表单页：`{模块名}-form.html`
- 详情页：`{模块名}-detail.html`

### 文件结构

生成的HTML文件包含：

```
<!DOCTYPE html>
<html>
<head>
    <title>页面标题</title>
    <!-- Remix Icon -->
    <link href="..." rel="stylesheet">
    <!-- Google Fonts -->
    <link href="..." rel="stylesheet">
    <style>
        /* CSS变量 */
        :root { ... }
        /* 组件样式 */
        ...
    </style>
</head>
<body>
    <!-- 侧边栏 -->
    <aside>...</aside>
    <!-- 主内容区 -->
    <main>
        <!-- 页头 -->
        <div class="ft-page-header">...</div>
        <!-- 内容区域 -->
        <div class="ft-page-content">...</div>
    </main>
</body>
</html>
```

### 预览方式

生成完成后，技能会自动在IDE预览窗口中打开页面。你也可以直接用浏览器打开生成的HTML文件。

## 自定义配置

### 修改CSS变量

编辑 `assets/css/ftdesign-vars.css` 可以自定义样式：

```css
:root {
    /* 修改品牌色 */
    --ft-brand-color: #FF5733;
    --ft-brand-color-hover: #FF6B4A;
    --ft-brand-color-active: #E64D2B;
    
    /* 修改侧边栏宽度 */
    --ft-sidebar-width: 200px;
}
```

### 修改模板

编辑 `assets/templates/` 目录下的模板文件，可以定制页面结构。

### 添加常用图标

在 `SKILL.md` 的"图标完整性"部分添加新的图标映射。

## 高级技巧

### 批量生成

对于复杂的多页面模块，可以一次性描述所有页面：

```
生成一个完整的权限管理模块，包含：
1. 角色列表页（角色名称、描述、状态、权限数）
2. 角色编辑页（角色名称、描述、权限选择）
3. 角色详情页（基本信息、权限列表）
4. 权限列表页（权限名称、模块、操作）
```

### 复制现有结构

如果想基于现有页面生成新页面：

```
基于cms-list.html生成一个用户列表页，将字段改为：用户名、邮箱、手机号、角色、注册时间
```

### 自定义操作列

可以指定表格操作列的按钮：

```
生成商品列表，操作列包含：查看、编辑、上架、下架按钮
```

## 常见问题

### Q：生成的页面样式不对怎么办？

A：检查是否正确引用了CSS变量，确保所有样式都使用了FTdesign的变量系统。

### Q：如何添加更多组件？

A：可以在模板中添加新的组件样式，或参考 `references/components-api.md` 中的组件文档。

### Q：生成的页面可以用于生产环境吗？

A：生成的HTML是原型/演示页面，用于预览设计效果。生产环境建议使用完整的前端框架（如React + Ant Design）。

### Q：如何禁用某些功能？

A：可以在需求中明确说明，例如："生成列表页，不需要查询功能"。

### Q：支持响应式设计吗？

A：生成的页面包含基本的响应式支持，使用百分比布局和flexbox。

## 最佳实践

1. **明确需求**：清晰描述页面类型和字段信息
2. **标记必填**：使用"(必填)"标注必填字段
3. **指定菜单**：明确侧边栏菜单项和图标
4. **说明操作**：详细说明需要的操作按钮
5. **提供示例**：如果有特殊的展示需求，提供示例数据

## 技术支持

如有问题，请检查：
1. SKILL.md 中的设计规范
2. references/ 目录下的参考文档
3. assets/templates/ 中的模板文件

## 版本历史

- **v1.0.0** (2024-02-26)：初始版本
  - 支持列表页、表单页、详情页生成
  - 完整的FTdesign设计规范
  - 自动侧边栏菜单生成
