# 子文档模板集（01~07）

> 本文件包含 guide/ 目录下 01~07 子文档的标准模板。
> 01-design、06-tech、07-plan 为必须文件；02~05 按项目类型选择。

---

## 01-design.md — 设计理念（必须）

```markdown
# 设计理念 & 项目定位

## 1. 设计理念

### 1.1 为什么做这个项目？
<!-- 项目的起源、灵感、要解决的问题 -->

### 1.2 核心设计原则
<!-- 项目遵循的设计原则（3-5条） -->

---

## 2. 与同类项目的关系

<!-- 如果有参考项目，说明复用策略和差异点 -->

| 维度 | 参考项目A | 本项目 |
|------|-----------|--------|
| 技术栈 | ... | ... |
| 架构 | ... | ... |
| 特色 | ... | ... |

**复用策略**:
- ✅ 复用：...
- ❌ 不复用：...
```

---

## 06-tech.md — 技术架构（必须）

```markdown
# 技术架构

## 文件结构

\`\`\`
project-root/
├── ...
└── ...
\`\`\`

## 核心类/模块设计

### 模块A（文件名）

\`\`\`javascript
class ModuleA {
    constructor()
    methodA()          // 功能描述
    methodB()          // 功能描述
}
\`\`\`

## 数据流/请求层次

\`\`\`
用户操作 → 前端组件 → API层 → 业务逻辑 → 数据层
\`\`\`

## 配置说明

| 配置项 | 默认值 | 说明 |
|--------|--------|------|
| ... | ... | ... |
```

---

## 07-plan.md — 开发计划（必须）

```markdown
# 开发计划

## 当前阶段：Phase N — 阶段名称

### 本阶段目标
- [ ] 目标1
- [ ] 目标2

### 分期计划

| 阶段 | 内容 | 状态 |
|------|------|------|
| Phase 1 | 基础骨架 | ✅ 完成 |
| Phase 2 | 核心功能 | 🔧 进行中 |
| Phase 3 | 优化完善 | ⏳ 待开始 |

### 下一步 TODO
- [ ] 待办1
- [ ] 待办2
```

---

## 02~05 按项目类型选择

### 🎮 游戏项目

```
02-map.md      — 地图/场景设计（布局、地标、配色、碰撞区域）
03-npc.md      — NPC/实体设计（角色设定、AI行为、日程表）
04-attributes.md — 属性/数值系统（属性定义、数值平衡、公式）
05-ai.md       — AI系统（Prompt设计、LLM集成、决策逻辑）
```

#### 02-map.md 模板

```markdown
# 地图 & 场景设计

## 场景列表

| 场景ID | 名称 | 尺寸 | 说明 |
|--------|------|------|------|
| ... | ... | ... | ... |

## 场景布局

### 主场景
<!-- ASCII图或说明 -->

## 配色方案

| 元素 | 颜色 | 用途 |
|------|------|------|
| ... | ... | ... |
```

#### 03-npc.md 模板

```markdown
# NPC/实体设计

## 角色列表

| 角色 | 职业 | 专长 | 备注 |
|------|------|------|------|
| ... | ... | ... | ... |

## 角色详细设计

### 角色名
- **年龄/性别**：...
- **性格**：...
- **专长**：...
- **日程表**：...
```

#### 04-attributes.md 模板

```markdown
# 属性 & 数值系统

## 属性列表

| 属性 | 范围 | 默认值 | 说明 |
|------|------|--------|------|
| ... | ... | ... | ... |

## 数值速查表

| 行动 | 效果 | 速率 | 备注 |
|------|------|------|------|
| ... | ... | ... | ... |
```

#### 05-ai.md 模板

```markdown
# AI 系统设计

## Prompt 设计

### 思考 Prompt（think）
<!-- system prompt 模板 -->

### 行动 Prompt（action）
<!-- system prompt 模板 -->

## LLM 集成

| 配置 | 值 | 说明 |
|------|----|------|
| 模型 | ... | ... |
| API | ... | ... |
| 参数 | ... | ... |
```

---

### 🌐 Web 应用项目

```
02-routes.md      — 路由设计（URL结构、权限、中间件）
03-components.md  — 组件设计（组件树、Props、状态流）
04-state.md       — 状态管理（Store设计、Action/Mutation）
05-api.md         — API设计（端点列表、请求/响应格式）
```

#### 02-routes.md 模板

```markdown
# 路由设计

## 路由表

| 路径 | 组件 | 权限 | 说明 |
|------|------|------|------|
| / | Home | public | 首页 |
| /login | Login | public | 登录 |
| /dashboard | Dashboard | auth | 仪表盘 |

## 中间件

| 名称 | 作用 | 应用范围 |
|------|------|----------|
| auth | 登录验证 | /dashboard/* |
```

#### 05-api.md 模板

```markdown
# API 设计

## 端点列表

| 方法 | 路径 | 说明 | 权限 |
|------|------|------|------|
| GET | /api/users | 用户列表 | admin |
| POST | /api/auth/login | 登录 | public |

## 请求/响应格式

### POST /api/auth/login

**请求**:
\`\`\`json
{ "username": "string", "password": "string" }
\`\`\`

**响应**:
\`\`\`json
{ "token": "string", "user": { "id": 1, "name": "string" } }
\`\`\`
```

---

### 🔧 CLI / 库项目

```
02-commands.md   — 命令设计（子命令、参数、选项）
03-modules.md    — 核心模块（模块职责、接口、依赖）
04-models.md     — 数据模型（结构定义、序列化、验证）
05-algorithms.md — 算法/逻辑（核心算法、流程图、复杂度）
```

---

### 📦 通用项目

```
02-architecture.md — 架构设计（分层、模块划分、通信机制）
03-modules.md      — 核心模块（模块职责、接口、依赖）
04-models.md       — 数据模型（实体定义、关系、存储）
05-logic.md        — 核心逻辑（业务规则、流程、算法）
```
