# 🚧 踩坑记录 & 开发注意事项

> 这是项目开发过程中积累的经验教训，都是实际遇到的坑。后续开发时务必参考此文档，避免重蹈覆辙。

---

<!-- 
## 踩坑记录格式规范

每条踩坑记录使用以下格式：

```markdown
## 🔥 坑N：简短标题

### 问题现象
具体描述遇到的问题，包括错误信息、异常行为等。
尽量包含实际的错误消息或截图描述。

### 问题根因
分析为什么会出现这个问题。
深入到代码/架构层面的原因，不要停留在表面现象。

### 解决方案
具体的修复步骤和代码改动。
如果涉及多个文件，逐一说明。

### ⚠️ 开发注意
- **加粗的通用原则**（从这个坑中提炼的普适性原则）
- 后续开发时的具体注意事项
- 相关的代码位置或检查点
```

### 编号规则
- 按发现顺序递增（坑1、坑2、坑3...）
- 新增的坑标记 🆕（下次更新时去掉）
- 不要删除已有的坑记录

### 通用原则标记
- 每条坑记录的"开发注意"中，第一条用 **加粗** 标记为通用原则
- 通用原则应该是可以直接作为开发约束使用的规则
- 文档末尾汇总所有通用原则

### 分类管理
- 坑记录超过 30 条时，建议按类型分组：
  - UI/渲染类
  - 数据/逻辑类
  - 异步/并发类
  - LLM/AI类
  - 性能类
  - 架构/设计类
-->

---

## 📋 通用开发原则（从以上踩坑总结）

### 1. {{PRINCIPLE_1_TITLE}}
{{PRINCIPLE_1_DESC}}

<!-- 
通用原则从踩坑记录中提炼，格式：
### N. 原则标题 🆕
原则描述。简明扼要，可以直接作为开发约束使用。

示例：
### 1. async 函数 await 后必须重新检查前置条件 🆕
NPC的很多操作是异步的，在 await 期间状态可能被其他系统改变。所有 async 函数在 await 之后都必须重新检查关键状态。

### 2. 多系统竞争的安全检查
每个系统在执行传送/状态切换前，都要检查当前状态是否允许。
-->
