# Guide 体系规范文档

> 本文档定义 project-guide 文档体系的完整规范。AI 在执行初始化/更新模式时，以本文档为权威参考。

---

## 1. 文件结构规范

### 1.1 目录结构

```
project-root/
├── start.md                      # 启动说明（必须）
└── guide/
    ├── guide.md                  # 项目总览索引（必须）
    ├── 01-design.md              # 设计理念（必须）
    ├── 02-{domain}.md            # 领域文档A（可选）
    ├── 03-{domain}.md            # 领域文档B（可选）
    ├── 04-{domain}.md            # 领域文档C（可选）
    ├── 05-{domain}.md            # 领域文档D（可选）
    ├── 06-tech.md                # 技术架构（必须）
    ├── 07-plan.md                # 开发计划（必须）
    ├── 08-changelog.md           # 更新日志（必须）
    ├── 09-pitfalls.md            # 踩坑记录（必须）
    └── archive/                  # 归档目录（自动创建）
```

### 1.2 必须文件 vs 可选文件

| 类型 | 文件 | 用途 |
|------|------|------|
| **必须** | `start.md` | 30秒知道怎么跑 |
| **必须** | `guide/guide.md` | 2分钟获得全景 |
| **必须** | `guide/01-design.md` | 为什么这样做 |
| **必须** | `guide/06-tech.md` | 技术实现细节 |
| **必须** | `guide/07-plan.md` | 进度和计划 |
| **必须** | `guide/08-changelog.md` | 改动记录 |
| **必须** | `guide/09-pitfalls.md` | 踩坑记录 |
| **可选** | `guide/02~05-*.md` | 按项目类型的领域文档 |

### 1.3 按项目类型的 02~05 映射

| 类型 | 02 | 03 | 04 | 05 |
|------|----|----|----|----|
| game | map(地图) | npc(NPC) | attributes(属性) | ai(AI) |
| web | routes(路由) | components(组件) | state(状态) | api(API) |
| cli/lib | commands(命令) | modules(模块) | models(模型) | algorithms(算法) |
| general | architecture(架构) | modules(模块) | models(模型) | logic(逻辑) |

---

## 2. 各文件章节要求

### 2.1 start.md

**用途**：让任何人（包括AI）在30秒内知道如何运行项目。

**必须章节**：
1. `# 项目名 — 简介` — 标题 + 一句话描述
2. `## 网页地址` — 服务/访问地址（如适用）
3. `## 启动服务` — 启动命令（代码块格式）
4. `## 关闭服务` — 关闭命令
5. `## 快速重启` — 重启命令
6. `## 项目文件说明` — 文件名+说明 的表格

**格式约束**：
- 启动命令必须是可直接复制执行的代码块
- 文件清单表列出所有关键源文件（不含 node_modules / dist / .git 等依赖/产物目录）
- 每个文件一行，说明控制在一句话以内

### 2.2 guide/guide.md

**用途**：项目上下文入口，AI 读取后能获得全景认知。

**必须章节**：
1. `# emoji 项目名 — 项目总览` — 标题
2. 元信息引用块（`>`）— 灵感来源、技术路线、核心目标、当前版本
3. `## 📋 文档索引` — 文档名+内容+说明 的表格
4. `## 🚀 快速开始` — 启动命令（代码块）
5. `## 🏗️ 当前核心系统` — Mermaid 架构图
6. 核心实体/模块概览表

**格式约束**：
- 版本号格式：`vX.Y`（主版本.次版本）
- 文档索引表中引用的文件**必须存在且内容非空**
- Mermaid 架构图使用 `graph LR` 或 `graph TD`
- 实体/模块概览表列出 5~15 个最重要的对象

### 2.3 guide/01-design.md

**用途**：解释"为什么这样做"，记录设计决策。

**必须章节**：
1. 设计理念 — 项目起源、核心设计原则
2. 与同类项目的关系 — 差异对比、复用策略（如适用）

### 2.4 guide/06-tech.md

**用途**：技术实现细节，帮助理解代码结构。

**必须章节**：
1. 文件结构 — 项目目录树
2. 核心类/模块设计 — 类名+方法签名+功能描述
3. 数据流/请求层次 — 数据如何流转

**可选章节**：
- 渲染层次（前端项目）
- 配置说明
- 第三方依赖说明

### 2.5 guide/07-plan.md

**用途**：跟踪开发进度和下一步计划。

**必须章节**：
1. 当前阶段 — Phase N 的名称和目标
2. 分期计划表 — 各阶段内容和状态
3. 下一步 TODO — 具体待办事项

### 2.6 guide/08-changelog.md

**用途**：详细记录每个版本的完整改动。

**条目格式**：
```markdown
## vX.Y — 标题摘要 (YYYY-MM-DD)

### 🎯 子系统名称（文件名）
- **`方法名()`**：具体改动描述

### 🐛 Bug修复
- **问题标题**：问题描述。修复：修复方式

### 📝 代码改动
- 文件名: 新增 `方法1()` + 修改 `方法2()`
```

**Emoji 约定**：🎯功能 🐛Bug 📝代码 🎉里程碑 🔧配置 🎨UI ⚡性能 🔄重构

**版本排序**：按时间倒序（最新在最上面）

**底部 Checklist**：维护已实现/未实现功能列表

### 2.7 guide/09-pitfalls.md

**用途**：经验教训沉淀，AI 可直接作为开发约束使用。

**条目格式**：
```markdown
## 🔥 坑N：简短标题

### 问题现象
具体错误信息或异常行为描述。

### 问题根因
代码/架构层面的深层原因分析。

### 解决方案
具体修复步骤和代码改动。

### ⚠️ 开发注意
- **加粗的通用原则**
- 后续开发的具体注意事项
```

**末尾汇总**：`## 📋 通用开发原则` 章节，汇总所有踩坑中提炼的通用原则

---

## 3. 版本号规范

### 3.1 格式

`vX.Y`（主版本.次版本）

### 3.2 递增规则

| 变更类型 | 版本变化 | 示例 |
|----------|----------|------|
| 新功能/系统 | +0.1 | v2.3 → v2.4 |
| 重大重构/架构变更 | +1.0 | v2.3 → v3.0 |
| Bug修复（多个） | +0.1 | v2.3 → v2.4 |
| 小修复（单个） | 不递增，记录在当前版本 | v2.3 |

### 3.3 版本号出现位置

- `guide/guide.md` 元信息中：`**当前版本**: vX.Y`
- `guide/08-changelog.md` 最新条目标题：`## vX.Y — 标题 (日期)`

两处必须保持同步。

---

## 4. 文档更新触发规则

### 4.1 触发矩阵

| 触发事件 | start.md | guide.md | 08-changelog | 09-pitfalls | 06-tech | 07-plan |
|----------|----------|----------|--------------|-------------|---------|---------|
| 完成功能开发 | 文件清单⚡ | 版本号⚡ | **必须** ✅ | 有坑则记 | — | checklist |
| 修复Bug | — | — | **必须** ✅ | 有经验则记 | — | — |
| 踩坑/发现问题 | — | — | — | **必须** ✅ | — | — |
| 新增/删除文件 | **必须** ✅ | — | — | — | 文件结构⚡ | — |
| 版本发布 | — | **必须** ✅ | **必须** ✅ | — | — | **必须** ✅ |
| 架构变更 | — | 架构图⚡ | **必须** ✅ | — | **必须** ✅ | — |

⚡ = 按需更新对应章节

### 4.2 AI 自动提醒规则

完成以下操作后，AI 应主动提示更新文档：
1. 完成功能开发 → 提醒更新 changelog
2. 修复 Bug → 提醒更新 changelog + 检查是否需要记录 pitfall
3. 新增文件 → 提醒更新 start.md 文件清单
4. 发现异常数值/行为 → 提醒记录 pitfall + 追加 changelog TODO

---

## 5. AI 上下文恢复推荐阅读顺序

### 5.1 标准恢复流程

```
第1步: start.md          → 知道怎么跑（30秒）
第2步: guide/guide.md    → 获得全景（2分钟）
第3步: 08-changelog.md   → 最新进展 + TODO（2分钟）
第4步: 09-pitfalls.md    → 通用原则章节（1分钟）
第5步: 按需读取 01~07    → 深入特定领域
```

### 5.2 各步骤提取信息

| 步骤 | 文件 | 提取信息 | 读取后能回答 |
|------|------|----------|--------------|
| 1 | start.md | 启动命令、文件清单 | 怎么跑？有哪些文件？ |
| 2 | guide.md | 技术栈、版本、架构图、实体列表 | 做什么的？用什么技术？当前进度？ |
| 3 | 08-changelog | 最新2-3版本改动、TODO | 最近做了什么？还有什么没做？ |
| 4 | 09-pitfalls | 通用原则汇总、最近5条坑 | 有什么注意事项？ |
| 5 | 01~07 | 按需深入 | 特定领域细节 |

### 5.3 快速恢复 vs 完整恢复

- **快速恢复**（日常开发）：只读 start.md + guide.md + changelog 最新版本
- **完整恢复**（首次接手/长时间未参与）：按 5.1 完整流程读取
- **问题排查**：先读 09-pitfalls 通用原则，再按问题类型读对应文档

---

## 6. 归档策略

### 6.1 Changelog 归档

**触发条件**：`08-changelog.md` 超过 500 行

**归档方式**：
1. 创建 `guide/archive/` 目录（如不存在）
2. 将旧版本条目移到 `guide/archive/changelog-vX.Y-vA.B.md`（X.Y 为最旧版本，A.B 为最新归档版本）
3. 在 `08-changelog.md` 顶部添加归档说明：`> 📦 旧版本已归档：[changelog-v0.1-v1.0.md](archive/changelog-v0.1-v1.0.md)`
4. 保留最近 3-5 个版本在主文件中

### 6.2 Pitfalls 分类

**触发条件**：踩坑记录超过 30 条

**分类方式**：
在文档顶部添加分类索引：
```markdown
## 📂 分类索引
- [UI/渲染类](#ui渲染类)：坑1, 坑3, 坑18, 坑21
- [异步/并发类](#异步并发类)：坑10, 坑8
- [LLM/AI类](#llmai类)：坑6, 坑7, 坑11
- [数据/逻辑类](#数据逻辑类)：坑9, 坑14, 坑15, 坑16
- [架构/设计类](#架构设计类)：坑2, 坑19, 坑20
```

不移动原有条目，只在顶部添加索引导航。

---

## 7. 文件保护规则

1. **不删除已有条目**：changelog 和 pitfalls 中的历史记录只追加，不删除
2. **索引一致性**：guide.md 文档索引表中引用的所有文件必须存在且内容非空
3. **版本号同步**：guide.md 和 changelog 中的版本号必须一致
4. **不修改归档文件**：archive/ 目录下的文件一旦归档，不再修改
5. **渐进式完善**：允许先创建骨架（占位符）后逐步填充内容，但不允许长期保持空文件
