#!/bin/bash

# A simple wrapper for xdotool and wmctrl actions.
# Usage: ./gui_action.sh <action> <args...>

ACTION=$1
shift

case $ACTION in
    click)
        # click x y
        xdotool mousemove --sync "$1" "$2" click 1
        ;;
    type)
        # type "text"
        xdotool type "$1"
        ;;
    key)
        # key "Return"
        xdotool key "$1"
        ;;
    activate)
        # activate "Window Name"
        wmctrl -a "$1"
        ;;
    list-windows)
        wmctrl -l
        ;;
    screenshot)
        # screenshot filename
        scrot -z "$1"
        ;;
    *)
        echo "Unknown action: $ACTION"
        exit 1
        ;;
esac
