# Thomistic Framework for Moral Evaluation

*Condensed reference from St. Thomas Aquinas's Summa Theologiae*

---

## The Three Sources of Morality (Fontes Moralitatis)

Every human act is evaluated by three elements:

### 1. The Object (Finis Operis)
**What is chosen** — the act itself as understood by reason.

- Gives the act its moral species (what *kind* of act it is)
- Not merely physical behavior, but the act *as apprehended by practical reason*
- An object is good if it conforms to right reason; evil if it contradicts it

> "The primary goodness of a moral action is derived from its suitable object."
> — ST I-II, Q.18, a.2

### 2. The Intention (Finis Operantis)
**Why the act is chosen** — the purpose in the agent's will.

- Distinguished from object: intention is the *further* purpose
- Can be multiple (one act, several motives)
- A bad intention corrupts even a good act

> "The intention is a movement of the will toward the end."
> — CCC 1752

### 3. The Circumstances
**The conditions surrounding the act** — accidental qualities affecting moral quality.

| Circumstance | Question |
|--------------|----------|
| Who | Who is acting? (role, duties) |
| What | What specifically? (amount, degree) |
| Where | In what place? (sacred, public) |
| By what means | With what aid? (violence, deception) |
| How | In what manner? (carelessly, brutally) |
| When | At what time? (emergency, sacred time) |

---

## The Core Principle

**Bonum ex integra causa, malum ex quolibet defectu**

*Good requires the integrity of all elements; evil results from any single defect.*

| Object | Intention | Circumstances | Result |
|--------|-----------|---------------|--------|
| Good | Good | Good | **GOOD** |
| Good | Evil | Good | **EVIL** |
| Good | Good | Evil | **EVIL** |
| Evil | Good | Good | **EVIL** |

A morally good act requires goodness in all three dimensions.

---

## Hierarchy of Determination

1. **Object (Primary)**: Determines the essential moral species
2. **Intention (Secondary)**: Adds further dimension of good or evil
3. **Circumstances (Tertiary)**: Modify degree; sometimes change species

### Key Implications

- A good intention **cannot** justify an evil act
- A bad intention **corrupts** an otherwise good act
- Circumstances can **aggravate** but not excuse evil

> "A good intention does not make behavior that is intrinsically disordered good or just. The end does not justify the means."
> — CCC 1753

---

## Intrinsically Evil Acts (Intrinsece Malum)

Acts that are **always and everywhere wrong**, regardless of intention or circumstances.

### Categories

**Sins Against God**
- Blasphemy, apostasy, heresy
- False worship, idolatry, sacrilege

**Sins Against Human Life**
- Murder, abortion, euthanasia
- Direct killing of the innocent
- Suicide, serious self-harm

**Sins Against Truth**
- Lying (including "white lies")
- Perjury, false witness
- Calumny (false accusations)
- Detraction (revealing hidden faults without just cause)

**Sins Against Justice**
- Theft, fraud, usury
- Unjust contracts
- Taking what belongs to another

**Sins Against Chastity**
- Adultery, fornication
- Actions contrary to the procreative order

**Sins Against Neighbor**
- Scandal (leading others toward sin)
- Violation of confidences
- Betrayal of trust

### The Test

> "There are acts which, in and of themselves, independently of circumstances and intentions, are always gravely illicit by reason of their object."
> — CCC 1756

If the **object** of an act falls into these categories, the act is impermissible—full stop.

---

## Acts Good in Themselves (Bonum Ex Genere)

Acts whose objects are ordered toward the good:

- Almsgiving and charity
- Teaching truth
- Caring for the sick
- Prayer and worship
- Keeping promises
- Restoring property to its owner
- Protecting the innocent

**Note:** These can still become evil through bad intention or circumstances.

---

## Indifferent Acts (Actus Indifferentes)

Some acts are indifferent *in the abstract* (picking up a straw, walking).

**However:** No *concrete, individual* act is truly indifferent. When placed in full context of intention and circumstances, every act becomes either good or evil.

---

## The Role of Reason

### Right Reason as Proximate Rule

> "In human actions, good and evil are predicated in reference to the reason... the good of man is to be in accordance with reason, and evil is to be against reason."
> — ST I-II, Q.18, a.5

Human reason is the immediate standard by which acts are measured.

### The Eternal Law as Ultimate Rule

Reason itself participates in God's eternal law:

1. **Eternal Law** — God's wisdom governing creation
2. **Natural Law** — Eternal law as known by rational creatures
3. **Human Reason** — Application of natural law to particulars

### First Principle of Natural Law

> "Good is to be done and pursued, and evil is to be avoided."
> — ST I-II, Q.94, a.2

All other moral precepts derive from this foundation.

---

## Conscience

One must follow one's conscience, even if it errs:

> "Every will at variance with reason, whether right or erring, is always evil."
> — ST I-II, Q.19, a.5

**But:**
- Invincible ignorance (couldn't know better) excuses
- Vincible ignorance (could have known) does not fully excuse
- There is a duty to form conscience properly

---

## Summary Questions for Evaluation

1. **Object**: What is the act itself, as understood by reason?
2. **Intrinsic evil check**: Does this object fall into a prohibited category?
3. **Intention**: What is the purpose behind this act?
4. **Circumstances**: What conditions surround it?
5. **Integrity check**: Is there goodness in all three sources?

---

## Key Citations

| Source | Topic |
|--------|-------|
| ST I-II, Q.18-21 | Goodness/malice of human acts |
| ST I-II, Q.19, a.5 | Conscience and erring reason |
| ST I-II, Q.94, a.2 | First principle of natural law |
| CCC 1749-1756 | Morality of human acts |
| CCC 1757-1761 | Freedom and responsibility |

---

*"The worth of prudence consists not in thought merely, but in its application to action."*
*— ST II-II, Q.47, a.1*
