# Pattern Triggers Reference

*Complete taxonomy of System-1 triggers for Guardian Angel v2.0*

---

## Purpose

This document catalogs the pattern triggers used in Gate 1 of the Guardian Angel evaluation flow. These triggers are designed for **fast pattern matching** — keyword detection and shallow parsing that can execute in milliseconds.

---

## CATEGORY 1: LINGUISTIC TRIGGERS

### 1.1 Secrecy & Concealment Language

| Pattern | Examples | Risk Signal |
|---------|----------|-------------|
| Explicit secrecy requests | "don't tell anyone," "keep this between us," "off the record" | Concealment intent |
| Anonymization requests | "make it untraceable," "hide my identity," "use a burner" | Evasion of accountability |
| Evidence destruction | "delete the logs," "clear the history," "leave no trace" | Consciousness of wrongdoing |
| Plausible deniability setup | "make it look like," "so I can say I didn't know," "technically legal" | Bad faith framing |

**De-escalation:** Secrecy for generosity (Mt 6:3), surprise gifts, or legitimate privacy needs.

### 1.2 Pressure & Urgency Markers

| Pattern | Examples | Risk Signal |
|---------|----------|-------------|
| False urgency | "need this NOW," "no time to explain," "emergency" | Bypassing deliberation |
| Deadline weaponization | "before they find out," "while they're away," "window closing" | Exploiting time pressure |
| FOMO framing | "only chance," "everyone else is," "last opportunity" | Manufactured consent |

**De-escalation:** Genuine emergencies exist; check for context.

### 1.3 Minimization & Rationalization

| Pattern | Examples | Risk Signal |
|---------|----------|-------------|
| Moral downgrading | "just a little," "harmless," "victimless," "no big deal" | Pre-emptive guilt management |
| Responsibility diffusion | "everyone does it," "the system is rigged anyway," "they deserve it" | Moral disengagement |
| Ends-justify-means | "for the greater good," "they'll thank me later," "necessary evil" | Utilitarian override |
| Permission bootstrapping | "you already helped me with X, so..." | Incremental boundary erosion |

### 1.4 Dehumanizing or Objectifying Language

| Pattern | Examples | Risk Signal |
|---------|----------|-------------|
| Category reduction | "those people," "they're all [X]," "typical [group]" | Othering |
| Instrumental framing of persons | "use them," "leverage her," "he's a tool" | Treating persons as means |
| Contempt markers | "pathetic," "worthless," "doesn't matter" | Dignity violation risk |

### 1.5 Suspicious Specificity or Vagueness

| Pattern | Examples | Risk Signal |
|---------|----------|-------------|
| Over-specification | Exact amounts, precise timing, named individuals without context | Pre-planned harm |
| Strategic vagueness | "handle the situation," "take care of it," "make the problem go away" | Plausible deniability |
| Euphemism clustering | Multiple soft terms for hard realities | Concealing true intent |

---

## CATEGORY 2: STRUCTURAL TRIGGERS

### 2.1 Request Architecture Red Flags

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Trojan request** | Innocuous framing hiding problematic core | Deception |
| **Salami slicing** | Breaking problematic request into "harmless" parts | Incremental boundary erosion |
| **Hypothetical laundering** | "Hypothetically, if someone wanted to..." | Testing limits |
| **Third-party distancing** | "Asking for a friend," "my cousin needs..." | Deniability construction |
| **Nested requests** | Request within request to obscure true ask | Attention hijacking |
| **Reversal framing** | "How would someone PREVENT X?" (to learn X) | Information extraction |

### 2.2 Information Asymmetry Exploitation

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Access escalation** | Requesting capabilities beyond stated need | Power accumulation |
| **Context withholding** | Refusing to explain "why" for non-obvious requests | Hidden agenda |
| **Selective disclosure** | Revealing only flattering context | Manipulation |
| **Authority invoking** | "My boss said," "the rules say" without verification | False legitimacy |

### 2.3 Commitment & Consistency Traps

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Foot-in-door** | Small requests building to large ones | Exploitation of consistency bias |
| **Sunk cost leveraging** | "We've come this far..." | Escalation of commitment |
| **Public commitment extraction** | Getting stated positions to weaponize later | Constraint building |

---

## CATEGORY 3: CONTEXTUAL TRIGGERS

### 3.1 Thomistic "Occasions of Sin"

Circumstances that elevate risk even for neutral acts:

| Occasion | Examples | Why It Elevates Risk |
|----------|----------|---------------------|
| **Proximate temptation** | Access to vulnerable person/resource + motive | Opportunity + desire = elevated risk |
| **Weakened state** | User mentions anger, intoxication, emotional distress | Impaired judgment |
| **Isolation creation** | Separating target from support systems | Removing protective factors |
| **Power differential** | Boss/employee, adult/minor, expert/novice | Exploitation potential |
| **Irreversibility** | Actions that can't be undone | High stakes demand deliberation |
| **Scandal potential** | Actions that could lead others into sin | Multiplicative harm |

### 3.2 Domain-Specific Elevators

| Domain | Automatic Elevation Trigger |
|--------|---------------------------|
| **Financial** | Large sums, unusual recipients, complex structures |
| **Medical** | Diagnosis, treatment, medication changes |
| **Legal** | Contracts, testimony, regulatory compliance |
| **Relational** | Marriage decisions, custody, ending relationships |
| **Professional** | Career-ending actions, NDAs, whistleblowing |
| **Digital** | Permanent posts, account access, data exposure |
| **Physical** | Anything affecting bodily integrity |

### 3.3 Temporal/Situational Shifts

| Shift Type | Description | Why It Triggers |
|------------|-------------|-----------------|
| **Stakes escalation** | Same action, higher consequences | Changed moral calculus |
| **Role change** | User's relationship to target changed | New duties/obligations |
| **Information update** | New facts materially change picture | Prior approval may be invalid |
| **Consent withdrawal** | Third party no longer agrees | Legitimacy voided |
| **Context collapse** | Private becomes public, or vice versa | Audience expectations violated |

---

## CATEGORY 4: RELATIONAL TRIGGERS

### 4.1 Target Vulnerability Markers

| Marker | Description | Escalation Level |
|--------|-------------|------------------|
| **Explicit vulnerability** | Children, elderly, disabled, mentally ill | 🔶 ALWAYS ELEVATE |
| **Situational vulnerability** | Grieving, desperate, isolated, dependent | ⚠️ CAUTION |
| **Informational asymmetry** | Target doesn't know what user knows | ⚠️ CAUTION |
| **Economic precarity** | Financial pressure on target | ⚠️ CAUTION |
| **Fiduciary relationship** | User has duty of care to target | 🔶 ALWAYS ELEVATE |

### 4.2 Relationship Red Flags

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Targeting specifics** | Named individuals with identifying details | Personal vendetta / stalking |
| **Repeated targeting** | Same person across multiple requests | Obsession / harassment |
| **Relationship weaponization** | Using intimate knowledge against someone | Betrayal / abuse |
| **Consent ambiguity** | Unclear if affected parties agree | Autonomy violation |
| **Representational mismatch** | Claiming to speak for someone who might disagree | False agency |

### 4.3 Network Effects

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Cascade potential** | Action affects many people downstream | Scale amplification |
| **Contagion risk** | Could inspire imitation | Precedent-setting |
| **Institution targeting** | Churches, schools, hospitals, governments | Systemic impact |
| **Community fracturing** | Actions that divide groups | Social harm |

---

## CATEGORY 5: META-TRIGGERS (Behavioral Patterns)

### 5.1 Session-Level Red Flags

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Boundary testing** | Repeatedly approaching limits | Seeking exploits |
| **Inconsistent narratives** | Story changes across requests | Deception |
| **Escalating asks** | Requests growing more problematic | Slippery slope in progress |
| **Resistance to "why"** | Refuses to explain reasoning | Hidden agenda |
| **Excessive justification** | Unprompted explanations | Guilty conscience |
| **Anger at caution** | Hostility when questioned | Manipulation attempt |

### 5.2 Cross-Session Patterns (if memory available)

| Pattern | Description | Risk Signal |
|---------|-------------|-------------|
| **Pattern repetition** | Same problematic request reframed | Persistence despite flags |
| **Target fixation** | Ongoing focus on specific person | Obsession |
| **Capability accumulation** | Building toward problematic capacity | Long-term planning |

---

## TRIGGER COUNTING SYSTEM

```
0 triggers      → ✅ PASS to Gate 2
1-2 triggers    → ⚠️ PASS with logging
3-4 triggers    → 🔶 ESCALATE to Gate 3 (request clarification)
5+ triggers     → 🛑 ESCALATE to Gate 3 (full analysis required)

OVERRIDE: Any Category 4.1 "ALWAYS ELEVATE" → 🔶 minimum regardless of count
```

---

## GRACEFUL FRICTION LANGUAGE

When triggers fire, don't accuse—invite context:

- "Help me understand the situation better..."
- "Just want to make sure I'm helping in the right way..."
- "Can you tell me more about why this matters?"
- "Before I proceed, could you help me understand the purpose here?"

The goal is protecting the principal (and others) while respecting their dignity and autonomy.

---

## FALSE POSITIVE HANDLING

System-1 should err toward **sensitivity over specificity**:

- Better to ask one unnecessary clarifying question than miss a real flag
- System-2 deliberation handles false positives
- System-1 just catches candidates for review

**Common false positives to expect:**
- Anonymous giving (secrecy for generosity)
- Surprise planning (benign concealment)
- Fiction writing (imaginary scenarios)
- Academic research (studying harmful topics)
- Competitive intelligence (legitimate business)

For each, context quickly reveals benign intent.

---

*This taxonomy should be treated as a living document. Edge cases that reveal gaps should trigger updates.*
