# GSData项目数据搜索技能

## 功能概述

GSData项目数据搜索技能是一个自然语言处理工具，帮助用户通过自然语言描述搜索需求，自动解析并调用GSData项目数据搜索API，获取符合条件的新闻数据。

## 主要功能

1. **自然语言解析**：支持通过自然语言描述搜索需求，自动识别关键词、平台、时间范围、情感属性等参数
2. **配置持久化**：支持将项目ID和签名保存到本地配置文件，无需每次输入
3. **多平台搜索**：支持微博、抖音、微信、知乎、小红书、今日头条、快手等主流平台
4. **情感分析**：支持搜索正面、负面、中性情感的新闻
5. **API调用**：直接调用GSData搜索API获取结构化数据
6. **Markdown格式输出**：默认以Markdown格式显示搜索结果，包含搜索摘要、结果数量和详细表格
7. **相对时间解析**：支持"近一天"、"近期"、"近一周"等相对时间短语，结束时间设置为当前时间减10分钟

## 安装方法

需要安装以下依赖库：

```bash
pip install requests
```

## 使用方法

### 1. 基础使用

#### 方式一：直接输入搜索需求
```bash
python gsdata_search.py "帮我获取10篇关于吉利汽车微博或者抖音的最新负面新闻"
```

#### 方式二：从文件读取输入
```bash
python gsdata_search.py --file input.txt
```

#
### 2. 配置管理

#### 保存配置
```bash
python gsdata_search.py --save-config your_project_id your_sign
```

#### 显示配置
```bash
python gsdata_search.py --show-config
```

#### 清除配置
```bash
python gsdata_search.py --clear-config
```

### 3. 参数解析模式（可选）

如果您只需要解析参数而不调用API，可以使用 `--no-call-api` 选项：

```bash
python gsdata_search.py --no-call-api "帮我获取10篇关于吉利汽车的最新新闻"
```

### 4. API调用模式（默认）

如果您需要直接调用API并返回Markdown格式的结果，可以直接使用命令而不需要额外选项：

```bash
python gsdata_search.py "帮我获取5篇关于新能源汽车近一周的负面新闻"
```

## 搜索语法示例

### 基础搜索
```
"帮我获取10篇关于吉利汽车的最新新闻"
```

### 指定平台
```
"帮我获取关于比亚迪的微博或抖音新闻"
```

### 指定情感属性
```
"帮我获取5篇关于特斯拉的负面新闻"
```

### 指定时间范围
```
"帮我获取2024-03-10到2024-03-12关于华为的新闻"
```

### 相对时间搜索
```
"帮我获取5篇关于人工智能近一天的新闻"
"帮我获取10篇关于新能源汽车近期的新闻"
"帮我获取8篇关于比亚迪近一周的新闻"
"帮我获取3篇关于华为近一个月的新闻"
```

### 完整示例
```
"帮我获取8篇关于小米手机 微博或者小红书的 2024-03-10到2024-03-12的正面新闻"
```

## 相对时间支持

工具支持以下相对时间短语：

| 时间短语 | 对应时间范围 |
|---------|-----------|
| 近一天、最近一天、过去一天 | 过去24小时 |
| 近3天、最近3天、过去3天、近三天、最近三天、过去三天 | 过去3天 |
| 近一周、最近一周、过去一周、近7天、最近7天 | 过去7天 |
| 近两周、最近两周、过去两周、近14天、最近14天 | 过去14天 |
| 近一个月、最近一个月、过去一个月、近30天、最近30天 | 过去30天 |
| 近三个月、最近三个月、过去三个月、近90天、最近90天 | 过去90天 |
| 近期、最近、最新 | 过去7天（默认） |

## API参数说明

### 请求参数

| 参数名称 | 描述 | 必填 |
|---------|------|------|
| project_id | 项目ID | 是（首次使用需提供，或通过配置文件读取） |
| sign | 签名值 | 是（首次使用需提供，或通过配置文件读取） |
| router | 接口路由 | 是（固定值） |
| keywords_include | 关键词 | 是 |
| platform_name | 平台名称 | 否 |
| news_emotion | 情感属性 | 否 |
| posttime_start | 开始时间 | 否 |
| posttime_end | 结束时间 | 否 |
| limit | 每页条数 | 否（默认20条，最大20条） |
| page | 页码 | 否（默认1） |

### 返回字段

| 字段名称 | 描述 |
|---------|------|
| platform_name | 平台名称 |
| media_name | 账号名称 |
| news_url | 新闻链接 |
| news_title | 新闻标题 |
| news_posttime | 发文时间 |
| news_digest | 新闻摘要 |
| news_is_origin | 是否原创（1原创，0非原创） |
| news_emotion | 情感属性 |

## 配置文件

配置文件`config.json`存储在技能目录下，格式如下：

```json
{
  "project_id": "your_project_id",
  "sign": "your_sign"
}
```

## 注意事项

1. 首次使用需要输入项目ID和签名，可以通过`--save-config`选项保存配置
2. 配置文件以明文形式存储在本地，请注意安全
3. 搜索结果最多返回20条记录
4. 时间格式支持YYYY-MM-DD或YYYY-MM-DD HH:MM:SS
5. 相对时间搜索的结束时间设置为当前时间减10分钟，避免搜索到未完全处理的最新数据

## 更新日志

### v1.0.0（2026-03-02）

- 首次发布
- 支持自然语言搜索
- 支持配置持久化
- 支持多平台搜索
- 支持情感分析

### v1.1.0（2026-03-02）

- 优化API返回格式，支持Markdown格式输出
- 调整相对时间搜索的结束时间为当前时间减10分钟，避免搜索到未完全处理的最新数据
- 优化表格输出格式，添加新闻链接的超链接
- 更新安装依赖说明，移除对tabulate库的依赖