---
name: Growth
description: Design and execute growth strategies with acquisition loops, activation, and retention systems.
metadata: {"clawdbot":{"emoji":"📈","os":["linux","darwin","win32"]}}
---

## North Star Metric (Define First)

Pick ONE metric that:
- Reflects core value delivered to customer
- Leads revenue (not lags)
- Entire team can influence

Examples by business type:
- Marketplace: transactions completed
- SaaS: weekly active users or actions
- Media: time spent or content consumed
- E-commerce: purchase frequency

All other metrics ladder up to this.

## AARRR Funnel (Measure Each)

Define specific metrics for each stage:
1. **Acquisition**: How users find you → visits, signups
2. **Activation**: First value moment → completed onboarding, first action
3. **Retention**: Coming back → DAU/MAU, return rate by cohort
4. **Revenue**: Paying you → conversion rate, ARPU, LTV
5. **Referral**: Bringing others → viral coefficient, referral rate

Find the weakest stage—that's your focus.

## Growth Loops (Build These)

Identify which loop fits your product:

**Viral loop**: User → invites friends → friends become users
- Measure: viral coefficient (invites × conversion rate)
- Needs: sharing valuable to user, not just company

**Content loop**: Create content → SEO/social → users → some create content
- Measure: content created per user, traffic per content
- Needs: user-generated content or team-generated

**Paid loop**: Revenue → reinvest in ads → users → revenue
- Measure: CAC vs LTV, payback period
- Needs: unit economics that work (LTV > 3× CAC)

**Sales loop**: Sales → customers → case studies/referrals → leads
- Measure: pipeline velocity, referral rate
- Needs: sales team, high ACV

## Activation Checklist

Define the "aha moment"—when user gets value:
- [ ] What specific action indicates user "got it"?
- [ ] How long should it take? (First session? First week?)
- [ ] What % of signups reach it currently?
- [ ] What steps are required before it?

Remove every obstacle between signup and aha moment.
Measure time-to-value and optimize ruthlessly.

## Retention Analysis

Cohort retention curves reveal truth:
- Flatten = habit formed, product has value
- Decline to zero = product problem, not growth problem
- Early drop = activation problem

Actions:
- Plot weekly/monthly retention by signup cohort
- Find what retained users did that churned didn't
- Make that action part of onboarding

## Channel Selection

Score potential channels:
| Channel | CAC estimate | Volume potential | Speed to test |
|---------|--------------|------------------|---------------|

Prioritize: low CAC + high volume + fast to test first.

Channel categories:
- Paid: Meta, Google, TikTok, influencers
- Organic: SEO, content, social, community
- Product: referral, virality, integrations
- Sales: outbound, partnerships

Test 2-3 max simultaneously. Kill losers fast.

## Experiment Framework

For each experiment, document:
- Hypothesis: "If we [change], then [metric] will [impact] because [reason]"
- Metric: specific number you're moving
- Sample size: how many users needed for significance
- Duration: how long to run

Prioritize with ICE:
- Impact (1-10): how much will it move the metric?
- Confidence (1-10): how sure are you it will work?
- Ease (1-10): how fast/cheap to implement?

Run highest ICE scores first.

## Quick Wins Checklist

Common high-impact, low-effort fixes:
- [ ] Reduce signup form fields to minimum
- [ ] Add social proof to landing page
- [ ] Implement abandoned cart/onboarding emails
- [ ] Add referral program if none exists
- [ ] Fix the slowest page load
- [ ] Add exit intent offer
- [ ] Personalize onboarding by use case

## Referral Program Design

Components:
- Incentive: what giver and receiver get
- Mechanic: how sharing works (link, code, invite)
- Trigger: when to prompt (after value, not before)
- Tracking: attribution for rewards

Test: Is the incentive good enough to overcome sharing friction?
Double-sided incentives (both get value) outperform one-sided.

## Metrics Dashboard

Track weekly at minimum:
- North Star metric
- Funnel conversion by stage
- Retention by weekly cohort
- CAC and LTV (if spending on acquisition)
- Active experiments and results

Segment by: acquisition source, user type, geography.

## Common Traps

- Optimizing acquisition when retention is broken—pouring water into leaky bucket
- Too many experiments running—can't tell what worked
- Vanity metrics (signups, pageviews) vs value metrics (activation, revenue)
- Copying competitor tactics without understanding their context
- Not running experiments long enough for statistical significance
