# Viral Loops — Growth Hacker

## Viral Coefficient Formula

```
K = i * c

K = Viral coefficient
i = Invitations sent per user
c = Conversion rate of invitations
```

| K Value | Growth Pattern |
|---------|---------------|
| K < 1 | Declining (need paid/organic) |
| K = 1 | Stable (replacing churn) |
| K > 1 | Exponential growth |

**Goal:** Get K above 1, even temporarily, to create growth spurts.

## Types of Viral Loops

### 1. Inherent Virality
Product requires sharing to function.

**Examples:**
- Slack (team communication)
- Splitwise (expense sharing)
- Multiplayer games

**Implementation:**
- Core feature involves others
- Value increases with more users
- Impossible to use alone

### 2. Artificial Virality
Incentivized sharing.

**Examples:**
- Dropbox (+500MB for referrals)
- Uber ($20 credit for referrals)
- PayPal ($10 for signups)

**Implementation:**
- Two-sided rewards (giver AND receiver)
- Instant gratification
- Clear value proposition

### 3. Word-of-Mouth Virality
Users share because product is remarkable.

**Examples:**
- ChatGPT (mind-blowing experience)
- Superhuman (status symbol)
- Notion (template sharing)

**Implementation:**
- Create "wow" moments
- Build shareable outputs
- Make users look good

### 4. Collaborative Virality
Working together spreads the product.

**Examples:**
- Google Docs (shared editing)
- Figma (design collaboration)
- Miro (team whiteboarding)

**Implementation:**
- Easy invite flow
- Guest access without signup
- Visible "Powered by X" branding

## Viral Loop Optimization

### Reduce Friction at Every Step

| Step | Friction Killers |
|------|-----------------|
| Trigger to share | One-click sharing, pre-written copy |
| Invitation delivery | SMS > Email > In-app |
| Landing experience | Personalized, shows who invited |
| Signup | Social login, minimal fields |
| First value | Immediate, connected to invitation |

### Increase Invitation Volume

- Prompt at peak happiness moments
- Gamify referrals (leaderboards)
- Remind about unused invites
- Make sharing part of core flow

### Improve Conversion Rate

- Personal invitations over broadcast
- Clear value proposition for invitee
- Urgency and scarcity
- Social proof (X friends already use this)

## Viral Timing Windows

| Moment | Why It Works |
|--------|-------------|
| After first success | User is happy, wants to share |
| During onboarding | Fresh excitement |
| Achievement unlocked | Pride moment |
| Before paywall | Earn access through sharing |

**Anti-pattern:** Asking for shares when user is frustrated or confused.

## Measuring Viral Success

### Track These Metrics

- **Invites per user:** How many people does each user invite?
- **Invite acceptance rate:** What percentage accept?
- **Time to invite:** How long before users invite?
- **Viral cycle time:** Days from signup to invitee signup

### Viral Cycle Time Matters

```
Users after 30 days with different cycle times:

Starting: 100 users, K = 1.5

Cycle time 2 days:  100 → 14,000 users
Cycle time 7 days:  100 → 1,200 users
Cycle time 30 days: 100 → 150 users
```

**Faster cycles = exponentially more growth.**

## Dark Patterns to Avoid

- Spam invites without consent
- Misleading invitation messages
- Forced sharing to access features
- Address book harvesting

These destroy trust and trigger platform bans.
