# Channel Playbooks — Growth Hacker

## Channel Selection Framework

### Bullseye Method

1. **Outer ring:** Brainstorm all possible channels (19+)
2. **Middle ring:** Test top 6 with cheap experiments
3. **Inner ring:** Focus on 1-2 that work

### The 19 Traction Channels

| # | Channel | Best For |
|---|---------|----------|
| 1 | Viral Marketing | Products with network effects |
| 2 | PR | Newsworthy launches, funding |
| 3 | Unconventional PR | Stunts, guerrilla marketing |
| 4 | SEM (Search Ads) | High-intent keywords |
| 5 | Social Ads | B2C, visual products |
| 6 | SEO | Long-term, content-heavy |
| 7 | Content Marketing | Thought leadership, education |
| 8 | Email Marketing | Existing lists, retention |
| 9 | Engineering as Marketing | Tools, calculators |
| 10 | Business Development | Partnerships, integrations |
| 11 | Sales | Enterprise, high ACV |
| 12 | Affiliate Programs | Products with margins |
| 13 | Existing Platforms | Marketplaces, app stores |
| 14 | Trade Shows | Industry-specific B2B |
| 15 | Offline Events | Local, community |
| 16 | Speaking Engagements | Founder brand |
| 17 | Community Building | Niche audiences |
| 18 | Influencer Marketing | Consumer products |
| 19 | Offline Ads | Mass market awareness |

## Channel-Specific Playbooks

### Product Hunt Launch

**Preparation (2-4 weeks before):**
- Build hunter relationships
- Gather testimonials and social proof
- Prepare assets (video, images, copy)
- Line up supporters to upvote and comment

**Launch Day:**
- Launch at 12:01 AM PT
- Founder engages in comments ALL day
- Share to existing audience (email, social)
- Do NOT ask directly for upvotes (against rules)

**Success metrics:**
- Top 5 = significant traffic
- #1 = long-term SEO and credibility

### Reddit Growth

**Rules:**
- 90% value, 10% promotion
- Become genuine community member first
- Never spam or self-promote obviously
- Follow subreddit rules strictly

**Tactics:**
- Answer questions in relevant subreddits
- Create genuinely useful resources
- Do AMAs when you have credibility
- Participate in discussions authentically

### Twitter/X Growth

**Content strategy:**
- Threads perform 5-10x better than single tweets
- Hook in first line (curiosity, controversy, value)
- Visual content gets 2-3x engagement
- Reply to bigger accounts in your niche

**Growth tactics:**
- Tweet 3-5 times daily
- Engage for 30 min before and after posting
- Build relationships with similar-sized accounts
- Cross-promote threads to other platforms

### TikTok/Reels/Shorts

**What works:**
- First 3 seconds hook is everything
- Native, raw content over polished
- Trends + your niche angle
- Behind-the-scenes, tutorials, reactions

**Volume matters:**
- Post 1-3 times daily minimum
- Expect 1 in 20 to hit
- Double down on formats that work

### Cold Email Outreach

**Formula:**
1. Personalized first line (real research)
2. One clear value proposition
3. Social proof (one line)
4. Single clear CTA
5. Keep under 100 words

**Best practices:**
- Warm up new domains before sending
- Respect anti-spam regulations (CAN-SPAM, GDPR)
- Provide clear unsubscribe options
- Monitor deliverability and bounce rates

### SEO for Startups

**Quick wins:**
- Target long-tail keywords (lower competition)
- Create comparison pages (vs competitors)
- Build tool pages that earn backlinks
- Guest post on industry blogs

**Programmatic SEO:**
- Generate pages at scale (location, category)
- Template + unique data = unique pages
- Examples: Zapier integrations, Nomadlist cities

## Channel Economics

| Metric | Formula | Target |
|--------|---------|--------|
| CAC | Total spend / New customers | Lower than LTV/3 |
| LTV | ARPU * Lifetime months | Higher than 3x CAC |
| Payback | CAC / Monthly revenue per user | Under 12 months |
| ROAS | Revenue / Ad spend | Above 3x |

## Channel Maturity Curve

1. **Discovery:** Channel is new, early adopters dominate
2. **Growth:** Channel scales, costs are low
3. **Saturation:** Everyone piles in, costs rise
4. **Decline:** Returns diminish, move on

**Strategy:** Enter channels in Discovery/Growth phase. Exit at Saturation.

## Multi-Channel Attribution

**Models:**
- **Last touch:** Credit to final channel
- **First touch:** Credit to discovery channel
- **Linear:** Equal credit to all touchpoints
- **Time decay:** More credit to recent touches

**Recommendation:** Use multi-touch for understanding, last-touch for optimization.
