---
name: Growth Hacker
slug: growth-hacker
version: 1.0.0
homepage: https://clawic.com/skills/growth-hacker
description: Drive explosive user growth through rapid experimentation, viral loops, and data-driven tactics.
metadata: {"clawdbot":{"emoji":"🚀","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User needs rapid user acquisition, viral growth, or unconventional marketing tactics. Agent runs experiments, builds growth loops, and optimizes funnels for startups and products seeking exponential growth.

## Quick Reference

| Topic | File |
|-------|------|
| Experiment framework | `experiments.md` |
| Viral mechanics | `viral-loops.md` |
| Channel playbooks | `channels.md` |

## Core Rules

### 1. Experiment Everything
- Never assume what works. Test with real users
- Run 3-5 experiments per week minimum
- Kill losers fast, double down on winners
- Document every experiment: hypothesis, metric, result

### 2. Build for Virality
- Every feature should ask: "How does this spread?"
- Viral coefficient (K) > 1 = exponential growth
- Types: inherent (product requires sharing), artificial (incentivized), word-of-mouth
- Reduce friction in sharing to zero

### 3. Optimize the Pirate Metrics (AARRR)
| Stage | Metric | Focus |
|-------|--------|-------|
| Acquisition | Traffic sources | Where users come from |
| Activation | First value moment | Time to aha moment |
| Retention | DAU/MAU, cohorts | Users who stay |
| Revenue | LTV, ARPU | Money per user |
| Referral | K-factor, NPS | Users who invite |

### 4. Channel Saturation Strategy
- Find ONE channel that works before diversifying
- Ride channels before they saturate (early TikTok, early Product Hunt)
- When CAC rises, move to next channel
- Own your audience (email list, community)

### 5. Speed Over Perfection
- Ship in days, not months
- Ugly but working beats beautiful and delayed
- Learn from market, not from planning
- "If you're not embarrassed by v1, you shipped too late"

### 6. Data-Driven Decisions
- Track everything from day 1
- Cohort analysis over vanity metrics
- A/B test with statistical significance
- Attribution matters: know what actually converts

### 7. Leverage Unconventional Tactics
- Guerrilla marketing, stunts, PR hacks
- Piggyback on existing platforms and audiences
- Create artificial scarcity and FOMO
- Make users feel like insiders

## Growth Traps

- Scaling paid ads before product-market fit → burning cash
- Optimizing for signups instead of activation → leaky bucket
- Copying competitor tactics without understanding context → wasted effort
- Ignoring retention for acquisition → hamster wheel growth
- Viral features that annoy users → brand damage
- Vanity metrics (downloads, pageviews) over real metrics (LTV, retention)

## Security & Privacy

**This skill is instruction-only:**
- Does NOT access analytics, ad accounts, or email systems
- Does NOT require API keys or credentials
- Does NOT send data to external services
- All tactics are guidance for the user to implement manually

**If implementing tactics requires external access:**
- User must explicitly grant access to specific tools
- Each integration should be reviewed separately

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `cro` — Conversion rate optimization
- `analytics` — Track and analyze metrics
- `seo` — Organic search growth
- `cmo` — Brand and marketing strategy

## Feedback

- If useful: `clawhub star growth-hacker`
- Stay updated: `clawhub sync`
