---
name: Grokipedia
description: Search and fetch articles from Grokipedia.com — xAI's AI-generated encyclopedia (like Wikipedia but written by Grok). Use when asked about topics that might have a Grokipedia article, or when the user explicitly mentions Grokipedia.
---

# Grokipedia Parser

Search and fetch articles from [Grokipedia.com](https://grokipedia.com) — xAI's AI-generated encyclopedia.

**Source:** [github.com/kirillleventcov/grokipedia-parser](https://github.com/kirillleventcov/grokipedia-parser)

## Requirements

- **Node.js** (v18+) / **Bun** — used to run the search and fetch scripts
- **Dependencies** — `jsdom` and `@mozilla/readability` (installed via `bun install`)

## Install

```bash
cd ~/.openclaw/workspace/skills/Grokipedia
bun install --production
```

> **Note:** Installation creates a `node_modules/` directory in the skill folder. The scripts themselves only output to stdout at runtime.

## Scripts

### Search Articles

```bash
node ~/.openclaw/workspace/skills/Grokipedia/scripts/search.mjs "query" [--limit N]
```

**Parameters:**
- `query` - Search term (required)
- `--limit N` - Max results (1-50, default: 10)

**Output:** JSON array with `slug`, `title`, `snippet`, `relevanceScore`

**Example:**
```bash
node ~/.openclaw/workspace/skills/Grokipedia/scripts/search.mjs "artificial intelligence" --limit 5
```

### Fetch Article

```bash
node ~/.openclaw/workspace/skills/Grokipedia/scripts/fetch.mjs "Article_Slug"
```

**Parameters:**
- `slug` - Article slug (required, case-sensitive, use underscores)

**Output:** Clean markdown article content

**Example:**
```bash
node ~/.openclaw/workspace/skills/Grokipedia/scripts/fetch.mjs "Helsinki"
node ~/.openclaw/workspace/skills/Grokipedia/scripts/fetch.mjs "Artificial_intelligence"
```

## What This Skill Does

- **Network access:** Fetches from `grokipedia.com` only (search API + article pages)
- **No credentials:** Public read-only access, no API keys or tokens needed
- **No runtime file writes:** Only outputs to stdout (JSON for search, markdown for articles). Install step creates `node_modules/` in the skill directory.
- **No persistence:** No background processes, no cron, no elevated privileges
- **Dependencies:** `jsdom` (DOM parsing) and `@mozilla/readability` (article extraction)

## Notes

- Article slugs are case-sensitive (e.g., `Helsinki` not `helsinki`)
- Slugs use underscores for spaces (e.g., `Artificial_intelligence`)
- Search returns up to 50 results max
- Articles contain internal links in format `[text](/page/Slug)`
- Content is AI-generated by Grok
