# Grokipedia Parser

Search and fetch articles from [Grokipedia.com](https://grokipedia.com) - xAI's AI-generated encyclopedia.

## Installation

```bash
cd ~/.openclaw/workspace/skills/Grokipedia
bun install --production
```

## Usage

### Search for Articles

```bash
node scripts/search.mjs "query" [--limit N]
```

**Options:**
- `query` - Search term (required)
- `--limit N` - Max results 1-50 (default: 10)

**Example:**
```bash
$ node scripts/search.mjs "artificial intelligence" --limit 3

{
  "query": "artificial intelligence",
  "resultCount": 3,
  "searchTimeMs": 15.2,
  "results": [
    {
      "slug": "Artificial_intelligence",
      "title": "Artificial intelligence",
      "snippet": "Artificial intelligence (AI) is the simulation of human intelligence...",
      "relevanceScore": 100000,
      "viewCount": 12345
    },
    ...
  ]
}
```

### Fetch an Article

```bash
node scripts/fetch.mjs "Article_Slug" [--raw]
```

**Options:**
- `slug` - Article slug from search results (required, case-sensitive)
- `--raw` - Output raw HTML instead of markdown

**Example:**
```bash
$ node scripts/fetch.mjs "Helsinki"

# Helsinki

*Source: https://grokipedia.com/page/Helsinki*

Helsinki is the capital and most populous municipality of Finland...
```

## Notes

- Article slugs are **case-sensitive** (e.g., `Helsinki` not `helsinki`)
- Slugs use underscores for spaces (e.g., `Artificial_intelligence`)
- Search returns up to 50 results maximum
- Content is AI-generated by Grok

## Dependencies

- `jsdom` - DOM parsing
- `@mozilla/readability` - Article extraction

## API Details

This parser uses:
- **Search**: `https://grokipedia.com/api/typeahead?query={q}&limit={n}`
- **Articles**: `https://grokipedia.com/page/{slug}` (with Readability extraction)

## License

MIT
