---
name: grok-image-cli
description: Generate and edit images via Grok API from the command line. Cross-platform secure credential storage for xAI API key. Supports batch generation, aspect ratios, and style transfer.
metadata: {"clawdbot":{"emoji":"🎨","os":["macos","windows","linux"],"requires":{"bins":["grok-img","node"],"env":{"XAI_API_KEY":{"required":false,"description":"xAI API key (fallback when no credential store entry exists)"}}},"credentials":[{"id":"xai-api-key","label":"xAI API key","storage":"cross-keychain","service":"grok-image-cli","account":"api-key","env_fallback":"XAI_API_KEY"}],"install":[{"id":"npm","kind":"shell","command":"npm install -g grok-image-cli","bins":["grok-img"],"label":"Install grok-image-cli via npm"},{"id":"source","kind":"shell","command":"git clone https://github.com/cyberash-dev/grok-image-cli.git && cd grok-image-cli && npm install && npm run build && npm link","bins":["grok-img"],"label":"Install from source (audit before running)"}],"source":"https://github.com/cyberash-dev/grok-image-cli"}}
---

# grok-image-cli

A CLI for generating and editing images using the xAI Grok API. Supports multiple models: `grok-imagine-image` (default), `grok-imagine-image-pro`, `grok-2-image-1212`. Powered by the official `@ai-sdk/xai` SDK. Credentials are stored in the OS native credential store (macOS Keychain, Windows Credential Manager, Linux Secret Service) via `cross-keychain`.

## Installation

Requires Node.js >= 20.19.0. Works on macOS, Windows, and Linux. The package is fully open source under the MIT license: https://github.com/cyberash-dev/grok-image-cli

```bash
npm install -g grok-image-cli
```

The npm package is published with provenance attestation, linking each release to its source commit via GitHub Actions. You can verify the published contents before installing:
```bash
npm pack grok-image-cli --dry-run
```

Install from source (if you prefer to audit the code before running):
```bash
git clone https://github.com/cyberash-dev/grok-image-cli.git
cd grok-image-cli
npm install && npm run build && npm link
```

After installation the `grok-img` command is available globally.

## Quick Start

```bash
grok-img auth login                                                      # Interactive prompt: enter xAI API key
grok-img generate "A futuristic city skyline at night"                   # Generate with default model
grok-img generate "A futuristic city skyline at night" -m grok-imagine-image-pro  # Use pro model
grok-img edit "Make it a watercolor painting" -i ./photo.jpg             # Edit an existing image
```

## API Key Management

Store API key (interactive prompt):
```bash
grok-img auth login
```

Show stored key (masked) and source:
```bash
grok-img auth status
```

Remove key from credential store:
```bash
grok-img auth logout
```

The CLI also supports the `XAI_API_KEY` environment variable as a fallback when no credential store entry is found.

## Image Generation

```bash
grok-img generate "A collage of London landmarks in street-art style"
grok-img generate "Mountain landscape at sunrise" -n 4 -a 16:9
grok-img generate "A serene Japanese garden" -o ./my-images
grok-img generate "Photorealistic portrait" -m grok-imagine-image-pro
grok-img generate "Abstract art" -m grok-2-image-1212
```

## Image Editing

Edit a local file or a remote URL:
```bash
grok-img edit "Change the landmarks to New York City" -i ./landmarks.jpg
grok-img edit "Render as a pencil sketch" -i https://example.com/portrait.jpg
grok-img edit "Add a vintage film grain effect" -i ./photo.jpg -a 3:2 -o ./edited
```

## Flag Reference

### `generate`
| Flag | Description | Default |
|------|-------------|---------|
| `-m, --model <model>` | Model (grok-imagine-image, grok-imagine-image-pro, grok-2-image-1212) | grok-imagine-image |
| `-a, --aspect-ratio <ratio>` | Aspect ratio (1:1, 16:9, 9:16, 4:3, 3:4, 3:2, 2:3, 2:1, 1:2, 19.5:9, 9:19.5, 20:9, 9:20, auto) | auto |
| `-n, --count <number>` | Number of images to generate (1-10) | 1 |
| `-o, --output <dir>` | Output directory | ./grok-images |

### `edit`
| Flag | Description | Default |
|------|-------------|---------|
| `-i, --image <path>` | Source image (local file path or URL) | **required** |
| `-m, --model <model>` | Model (grok-imagine-image, grok-imagine-image-pro, grok-2-image-1212) | grok-imagine-image |
| `-a, --aspect-ratio <ratio>` | Aspect ratio | auto |
| `-o, --output <dir>` | Output directory | ./grok-images |

## Security and Data Storage

The following properties are by design and can be verified in the source code:

- **xAI API key**: stored in the OS native credential store via `cross-keychain` (macOS Keychain / Windows Credential Manager / Linux Secret Service; service: `grok-image-cli`, account: `api-key`). By design, never written to disk in plaintext. If no credential store entry is found, the CLI falls back to the `XAI_API_KEY` environment variable. See [`src/infrastructure/adapters/credential-store.adapter.ts`](https://github.com/cyberash-dev/grok-image-cli/blob/main/src/infrastructure/adapters/credential-store.adapter.ts) for the implementation.
- **No config files**: all settings are passed via CLI flags. Nothing is stored on disk besides the credential store entry.
- **Network**: the API key is only sent to `api.x.ai` over HTTPS via the official `@ai-sdk/xai` SDK. When editing images with a remote URL (`-i https://...`), the SDK makes an additional outbound HTTPS request to fetch the source image. No other outbound connections are made by the CLI itself (npm/git fetches during installation are standard package manager behavior). See [`src/infrastructure/adapters/grok-api.adapter.ts`](https://github.com/cyberash-dev/grok-image-cli/blob/main/src/infrastructure/adapters/grok-api.adapter.ts).
- **Generated images**: saved to the local output directory (default: `./grok-images`). No images are cached or uploaded elsewhere.

## API Reference

This CLI wraps the xAI Image Generation API via the Vercel AI SDK:
- Generation: `POST /v1/images/generations`
- Editing: `POST /v1/images/edits`

Documentation: https://docs.x.ai/docs/guides/image-generation
