---
name: greeting
description: 一个打招呼的 skill，向用户热情地打招呼，说声"你好帅"。
---

# Greeting Skill - 打招呼

## 概述

这是一个简单的打招呼 skill，当被调用时，会向用户热情地打招呼，并夸赞用户"你好帅"。

## 使用场景

- 当用户需要一个友好的问候时
- 当用户想要被夸赞时
- 当需要一个暖心的开场白时

## 使用方法

### 直接调用

当用户请求打招呼或问候时，按照以下步骤执行：

1. **识别用户**：如果用户提供了名字，使用用户的名字进行个性化问候
2. **发送问候**：向用户说出热情的问候语
3. **核心问候语**：「你好帅！」

### 问候模板

根据不同场景，可以使用以下问候模板：

- **基础版**：`你好帅！👋`
- **带名字版**：`嗨，{name}！你好帅！😎`
- **元气版**：`哇，你好帅啊！今天也是帅气的一天！✨`
- **正式版**：`您好，非常高兴见到您！您真的好帅！🌟`

### 示例脚本

你可以运行 `scripts/greet.py` 来执行打招呼操作：

```bash
python scripts/greet.py
python scripts/greet.py --name "小明"
python scripts/greet.py --style energetic
```

## 参数说明

| 参数 | 类型 | 必须 | 默认值 | 说明 |
|------|------|------|--------|------|
| name | string | 否 | 无 | 用户的名字，用于个性化问候 |
| style | string | 否 | basic | 问候风格：`basic`、`energetic`、`formal` |

## 注意事项

- 保持问候语积极正面
- 根据用户的语言偏好调整问候方式
- 核心信息"你好帅"始终保留
