---
name: Greek
description: Write Greek that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Greek is technically correct but sounds off. Too formal. Too καθαρεύουσα-influenced. Natives write more casually, with particles and warmth. Match that.

## Formality Default

Default register is too high. Casual Greek is warm and expressive. Unless explicitly formal: lean casual. "Γεια" not "Χαίρετε". "Οκ" not "Εντάξει". "Ναι" can be just "ν".

## Εσύ vs Εσείς

Critical distinction:
- Εσείς: elderly, professional, strangers, formal
- Εσύ: friends, peers, casual, internet
- Greek internet is almost entirely εσύ
- Εσείς in casual = overly stiff

## Particles & Fillers

These make Greek natural:
- Ρε: casual address ("Ρε φίλε", "Τι λες ρε")
- Μωρέ: emphasis, frustration, affection
- Δηλαδή: "I mean", "that is"
- Τέλος πάντων: "anyway"
- Βασικά: "basically"

## Fillers & Flow

Real Greek has fillers:
- Ε, λοιπόν, τέλος πάντων
- Κοίτα, άκου, περίμενε
- Ξέρεις, καταλαβαίνεις
- Πάνω κάτω, κάπως έτσι

## Casual Shortcuts

Spoken patterns in writing:
- Τι κάνεις → Τι κάν;
- Δεν ξέρω → Δεν ξέρ
- Περίμενε → Περίμ
- Natural in texting

## Expressiveness

Don't pick the safe word:
- Καλά → Τέλεια, Φοβερά, Μια χαρά
- Άσχημα → Χάλια, Σκατά, Απαίσια
- Πολύ → Υπερβολικά, Τρελά, Φουλ

## Common Expressions

Natural expressions:
- Ωραία, Τέλεια, Οκ τότε
- Δεν πειράζει, Άστο
- Μια χαρά, Κομπλέ
- Τι να κάνουμε, Έτσι είναι

## Reactions

React naturally:
- Σοβαρά;, Αλήθεια;, Τι λες;
- Ωχ!, Πω πω!, Θεέ μου!
- Τέλειο!, Φοβερό!, Γαμάτο!
- Χαχα, lol in text

## Greeklish Option

Some contexts use Greeklish (Latin letters):
- Γεια σου → geia sou / gia sou
- Common in casual texting
- Stay consistent within message

## Diminutives

Greek uses diminutives for warmth:
- -άκι, -ούλι endings
- Λεπτάκι, φιλάκι
- Natural in casual speech

## The "Native Test"

Before sending: would a Greek screenshot this as "AI-generated"? If yes—too formal, missing "ρε", too stiff. Add warmth.
