# Security Policy

Last updated: February 19, 2026

## Safe Harbor

We welcome good-faith security research and responsible disclosure.
If you follow this policy, RustChain / BoTTube / Elyan Labs maintainers will treat your work as authorized and will not pursue legal action for good-faith testing.

Good-faith means:
- Avoid service disruption, data destruction, or privacy harm.
- Do not exploit for personal gain.
- Give us reasonable time to fix before public disclosure.

## Disclosure Channels

Preferred:
- GitHub Security Advisories (Private Vulnerability Reporting) for this repository.

Fallback:
- Open an issue with `question/security` if private reporting is unavailable.

Please include:
- Affected endpoint/component
- Reproduction steps
- Impact and severity
- Suggested mitigation (if available)

## Scope

In scope:
- API auth, rate limiting, replay/nonce handling
- wallet/payment logic and settlement paths
- transport/integration security boundaries
- dependency and supply-chain risks

Out of scope:
- social engineering
- physical attacks
- denial-of-service against production infra

## Response Targets

- Acknowledgment: within 48 hours
- Initial triage: within 5 business days
- Fix/mitigation target: 30-45 days (faster for critical issues)

## Bounty and Rewards

Valid reports may receive RTC payouts via project bounty workflows.

Important:
- RTC payouts are recognition for open-source contribution and security work.
- No ICO was performed for this project.
- No guarantee is made regarding token liquidity, market value, or future price.
- Participation is voluntary and contribution-driven.

## Attribution

With consent, valid reporters can be credited in release notes / Hall of Hunters records.
