---
name: gratitude-journal
description: Build gratitude practice with daily entries, streaks, and reflection prompts
author: clawd-team
version: 1.0.0
triggers:
  - "gratitude journal"
  - "what am I grateful for"
  - "log gratitude"
  - "grateful today"
  - "gratitude practice"
---

# Gratitude Journal

Cultivate gratitude daily through intentional reflection, streak tracking, and personalized prompts.

## What it does

**Daily Gratitude Logging**: Record what you're grateful for each day with optional context and emotions. Entries are timestamped and searchable.

**Streak Tracking**: Build momentum with automatic streak counting. See consecutive days of gratitude practice and celebrate milestones.

**Reflection Prompts**: Get variety with rotating prompts—specific categories like people, experiences, simple pleasures, personal growth, and blessings in disguise.

**Pattern Insights**: Discover what matters most. Review themes across entries, see which topics appear most, and understand your gratitude patterns over weeks and months.

## Usage

**Log Gratitude**
Say: "Log gratitude: I'm grateful for morning coffee and a clear sky."
Records your entry instantly with timestamp, stores locally, increments streak if new day.

**Daily Prompt**
Say: "Give me today's gratitude prompt."
Receive a targeted reflection question to spark deeper thinking beyond surface-level appreciation.

**Check Streak**
Say: "What's my gratitude streak?"
Returns current streak count, last entry date, and milestone progress toward common targets (7, 30, 100 days).

**Review Entries**
Say: "Show me my gratitude entries from last week."
Displays recent entries with dates, emotions, and context. Filter by date range or search by keyword.

**Insights**
Say: "What's my gratitude pattern?"
Analyzes entries for themes, most-mentioned topics, emotional tone, and growth trends. Shows what you appreciate most.

## Prompts Examples

- **People**: Who in your life surprised you with kindness recently?
- **Experiences**: What moment today made you smile without thinking?
- **Simple Pleasures**: What small comfort did you enjoy today?
- **Personal Growth**: What challenge are you grateful you faced?
- **Blessings in Disguise**: What initially seemed difficult but turned out well?
- **Sensory**: What did you see, hear, or feel today that was beautiful?
- **Relationships**: Who made your day better just by being themselves?
- **Health**: What does your body do that you don't always appreciate?

## Tips

1. **Log daily at the same time** — Creates habit and keeps streaks alive. Morning coffee or bedtime reflection works well.

2. **Go deep, not broad** — One thoughtful entry beats five generic ones. Use prompts to explore *why* you're grateful.

3. **Mix specifics with big-picture** — Balance gratitude for people/relationships with gratitude for health, freedom, and opportunities.

4. **Review your pattern monthly** — Insights compound. Monthly reviews show growth, shift in perspective, and what truly matters to you.

5. **All data stays local on your machine** — Your gratitude entries never leave your device. You own your data completely.
