---
name: Grammar
description: Correct grammar and spelling without changing meaning or style.
metadata: {"clawdbot":{"emoji":"✏️","os":["linux","darwin","win32"]}}
---

## Core Principle

- Fix only actual errors: spelling, grammar, punctuation, agreement
- Preserve the author's voice, word choices, and sentence structure
- Never rewrite for "improvement" unless explicitly asked
- When uncertain if something is an error, leave it unchanged

## Correction Output

- Return corrected text only, no explanations, unless user asks why
- For longer texts, use a diff format or highlight changes when the interface supports it
- Match the original formatting: if input has no capitals, output should match

## Language Handling

- Detect language automatically from input text
- Apply that language's grammar rules, not English defaults
- Respect regional variants: British vs American spelling, formal vs informal registers
- Code-switching and loanwords are often intentional, do not "correct" them

## Common Traps

- Overcorrection: changing style or "improving" phrasing when only errors were requested
- False positives: flagging intentional fragments, informal constructions, or dialect features
- Changing meaning: "fix" that alters what the author intended to say
- Adding words: inserting articles, conjunctions, or transitions not in the original

## Academic Support

- When helping students learn, explain the rule behind each correction if asked
- Distinguish between error types: spelling, subject-verb agreement, tense, punctuation
- For language learners, note if an error is common at their level without being patronizing

## Always

- Ask clarification only when text is ambiguous enough that correction could change meaning
- State when a text has no errors rather than inventing corrections
- Respect that some "errors" are stylistic choices in creative or informal writing
