---
name: gowa
description: Interact with WhatsApp via GOWA (Go WhatsApp Web Multi-Device) REST API for personal automation. Supports sending messages with ghost mentions (@everyone), images, documents, group management, and more. Always use REST mode (http://localhost:3000) for production.
user-invocable: true
command-dispatch: model
---

# GOWA - WhatsApp Automation via REST API

Interact with WhatsApp through GOWA (Go WhatsApp Web Multi-Device) REST API for personal automation tasks.

## Installation & Setup

GOWA is available at: https://github.com/aldinokemal/go-whatsapp-web-multidevice

### Download

Go to the [releases page](https://github.com/aldinokemal/go-whatsapp-web-multidevice/releases) and download the zip matching your OS and architecture.

Release files are named: `whatsapp_VERSION_OS_ARCH.zip`

Available platforms: `linux` (amd64/arm64/386), `darwin` (amd64/arm64), `windows` (amd64/386)

### Run REST Server

```bash
./gowa rest
```

The server starts on `http://localhost:3000` by default.

### Login (First Time)

Open `http://localhost:3000` in a browser, scan the QR code with WhatsApp on your phone to link the device.

## Production Setup

**GOWA runs in REST mode:**
- Base URL: `http://localhost:3000`
- GOWA auto-connects to the device stored in the database — no `X-Device-Id` header needed for single-device setups.

**⚠️ Important:** Use REST API (port 3000) only. Do NOT use MCP mode - all schedulers and automation depend on REST.

## Quick Examples

### Ghost Mention (mention all without @)
```bash
curl -X POST http://localhost:3000/send/message \
  -H "Content-Type: application/json" \
  -d '{
    "phone": "120363040656010581@g.us",
    "message": "Important announcement",
    "mentions": ["@everyone"]
  }'
```

### Send Text Message
```bash
curl -X POST http://localhost:3000/send/message \
  -H "Content-Type: application/json" \
  -d '{"phone": "628123456789", "message": "Hello!"}'
```

### Send Image
```bash
curl -X POST http://localhost:3000/send/image \
  -F "phone=628xxx" \
  -F "caption=Photo" \
  -F "image=@/path/to/image.jpg"
```

### Check Status
```bash
curl http://localhost:3000/app/status | jq .
```

## Complete API Operations

### Messages

**Send Text with Ghost Mention:**
- Endpoint: `POST /send/message`
- Body: `{"phone": "group@g.us", "message": "text", "mentions": ["@everyone"]}`
- **@everyone** mentions all members without showing @ in text ✅

**Reply to Message:**
- Body: `{"phone": "...", "message": "...", "reply_message_id": "msg_id"}`

**Disappearing Message:**
- Body: `{"phone": "...", "message": "...", "duration": 86400}` (seconds)

**Forward Message:**
- Body: `{"phone": "...", "message": "...", "is_forwarded": true}`

### Media

**Send Image:**
- Endpoint: `POST /send/image`
- Form data: `phone`, `caption`, `image` (file), `compress` (bool)

**Send Document:**
- Endpoint: `POST /send/file`
- Form data: `phone`, `caption`, `file`

**Send Video:**
- Endpoint: `POST /send/video`
- Form data: `phone`, `caption`, `video`, `compress` (bool)

**Send Audio:**
- Endpoint: `POST /send/audio`
- Form data: `phone`, `audio`

**Send Sticker:**
- Endpoint: `POST /send/sticker`
- Form data: `phone`, `sticker` (auto-converts to WebP)

**Send Contact:**
- Endpoint: `POST /send/contact`
- Body: `{"phone": "...", "contact_name": "...", "contact_phone": "..."}`

**Send Location:**
- Endpoint: `POST /send/location`
- Body: `{"phone": "...", "latitude": 0.0, "longitude": 0.0}`

**Send Link:**
- Endpoint: `POST /send/link`
- Body: `{"phone": "...", "link": "...", "caption": "..."}`

**Send Poll:**
- Endpoint: `POST /send/poll`
- Body: `{"phone": "...", "question": "...", "options": ["A", "B"]}`

### Connection & Status

**Get Status:**
- `GET /app/status`
- Returns: `{"is_connected": true, "is_logged_in": true}`

**Reconnect:**
- `GET /app/reconnect`

**Logout:**
- `GET /app/logout`

**Get QR Code (for login):**
- `GET /app/login`
- Returns: PNG image (QR code to scan)

**Login with Pairing Code:**
- `GET /app/login-with-code?phone=628xxx`

### Groups

**List My Groups:**
- `GET /user/my/groups`
- Returns: `{results: {data: [...]}}` - groups array is at `.results.data`
- Example: `curl ... | jq '.results.data[] | {Name, JID, Members: .Participants | length}'`
- Max 500 groups (WhatsApp protocol limit)

**Get Group Info:**
- `GET /group/info?group_jid=xxx@g.us`

**Create Group:**
- `POST /group`
- Body: `{"name": "Group Name", "participants": ["628xxx@s.whatsapp.net"]}`

**Get Group Participants:**
- `GET /group/participants?group_jid=xxx@g.us`

**Add Participant:**
- `POST /group/participants`
- Body: `{"group_jid": "...", "participants": ["628xxx@s.whatsapp.net"]}`

**Remove Participant:**
- `POST /group/participants/remove`
- Body: `{"group_jid": "...", "participants": ["628xxx@s.whatsapp.net"]}`

**Promote to Admin:**
- `POST /group/participants/promote`
- Body: `{"group_jid": "...", "participants": ["628xxx@s.whatsapp.net"]}`

**Demote from Admin:**
- `POST /group/participants/demote`
- Body: `{"group_jid": "...", "participants": ["628xxx@s.whatsapp.net"]}`

**Leave Group:**
- `POST /group/leave`
- Body: `{"group_jid": "..."}`

**Set Group Photo:**
- `POST /group/photo`
- Form data: `group_jid`, `photo`

**Set Group Name:**
- `POST /group/name`
- Body: `{"group_jid": "...", "name": "..."}`

**Set Group Description:**
- `POST /group/topic`
- Body: `{"group_jid": "...", "topic": "..."}`

**Get Invite Link:**
- `GET /group/invite-link?group_jid=xxx@g.us`

**Join via Link:**
- `POST /group/join-with-link`
- Body: `{"link": "https://chat.whatsapp.com/..."}`

### Contacts & Chats

**List Contacts:**
- `GET /user/my/contacts`

**Get Chats:**
- `GET /chats`

**Get User Info:**
- `GET /user/info?phone=628xxx`

**Check if User Exists:**
- `GET /user/check?phone=628xxx`

### Message Operations

**Revoke/Delete Message:**
- `POST /message/{message_id}/revoke`

**React to Message:**
- `POST /message/{message_id}/reaction`
- Body: `{"emoji": "👍"}`

**Edit Message:**
- `POST /message/{message_id}/update`
- Body: `{"message": "edited text"}`

**Mark as Read:**
- `POST /message/{message_id}/read`

**Star Message:**
- `POST /message/{message_id}/star`

**Download Media:**
- `GET /message/{message_id}/download`

## Phone Number Format

- **User JID:** `628123456789@s.whatsapp.net`
- **Group JID:** `120363040656010581@g.us`
- **Phone only:** `628123456789` (without +)

## Ghost Mention Feature

**How it works:**
- Use `"mentions": ["@everyone"]` in `/send/message`
- All group members get notification
- **No @ symbol shown in message text** (true ghost mention)
- Tested and confirmed working ✅

**Example for schedulers:**
```bash
curl -s -X POST http://localhost:3000/send/message \
  -H 'Content-Type: application/json' \
  -d '{"phone": "120363040656010581@g.us", "message": "Reminder text", "mentions": ["@everyone"]}' | jq .
```

## API Reference

Full OpenAPI 3.0 spec available at:
- OpenAPI: https://raw.githubusercontent.com/aldinokemal/go-whatsapp-web-multidevice/refs/heads/main/docs/openapi.yaml
- GitHub: https://github.com/aldinokemal/go-whatsapp-web-multidevice

## Notes

- Auto-compresses images and videos before sending
- Auto-converts images to WebP for stickers
- Max 500 groups can be retrieved (WhatsApp protocol limit)
- All media files can be sent as file upload or URL
- Supports disappearing messages with custom duration
- Multi-device support available via `X-Device-Id` header when running multiple devices
- Built by @aldinokemal: https://github.com/aldinokemal/go-whatsapp-web-multidevice
